/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import ghidra.util.Swing;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

public abstract class SwingExecutorService
extends AbstractExecutorService {
    public static final SwingExecutorService LATER = new SwingExecutorService(){

        @Override
        public void execute(Runnable command) {
            SwingUtilities.invokeLater(command);
        }
    };
    public static final SwingExecutorService MAYBE_NOW = new SwingExecutorService(){

        @Override
        public void execute(Runnable command) {
            Swing.runIfSwingOrRunLater((Runnable)command);
        }
    };

    private SwingExecutorService() {
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }
}

