/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.AbstractWeakValueMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedMap;

public abstract class AbstractWeakValueNavigableMap<K, V>
extends AbstractWeakValueMap<K, V>
implements NavigableMap<K, V> {
    @Override
    protected abstract NavigableMap<K, AbstractWeakValueMap.WeakValueRef<K, V>> getRefMap();

    @Override
    public Comparator<? super K> comparator() {
        return this.getRefMap().comparator();
    }

    @Override
    public K firstKey() {
        this.processQueue();
        return this.getRefMap().firstKey();
    }

    @Override
    public K lastKey() {
        this.processQueue();
        return this.getRefMap().lastKey();
    }

    protected AbstractWeakValueMap.GeneratedEntry generateEntry(Map.Entry<K, AbstractWeakValueMap.WeakValueRef<K, V>> ent) {
        if (ent == null) {
            return null;
        }
        return new AbstractWeakValueMap.GeneratedEntry(this, ent.getKey(), ent.getValue().get());
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        this.processQueue();
        return this.generateEntry(this.getRefMap().lowerEntry(key));
    }

    @Override
    public K lowerKey(K key) {
        this.processQueue();
        return this.getRefMap().lowerKey(key);
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        this.processQueue();
        return this.generateEntry(this.getRefMap().floorEntry(key));
    }

    @Override
    public K floorKey(K key) {
        this.processQueue();
        return this.getRefMap().floorKey(key);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        this.processQueue();
        return this.generateEntry(this.getRefMap().ceilingEntry(key));
    }

    @Override
    public K ceilingKey(K key) {
        this.processQueue();
        return this.getRefMap().ceilingKey(key);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        this.processQueue();
        return this.generateEntry(this.getRefMap().higherEntry(key));
    }

    @Override
    public K higherKey(K key) {
        this.processQueue();
        return this.getRefMap().higherKey(key);
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        this.processQueue();
        return this.generateEntry(this.getRefMap().firstEntry());
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        this.processQueue();
        return this.generateEntry(this.getRefMap().lastEntry());
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        this.processQueue();
        return this.generateEntry(this.getRefMap().pollFirstEntry());
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        this.processQueue();
        return this.generateEntry(this.getRefMap().pollLastEntry());
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        this.processQueue();
        return new NavigableView(this, this.getRefMap().descendingMap());
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return this.getRefMap().navigableKeySet();
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.getRefMap().descendingKeySet();
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        this.processQueue();
        return new NavigableView(this, this.getRefMap().subMap(fromKey, fromInclusive, toKey, toInclusive));
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        this.processQueue();
        return new NavigableView(this, this.getRefMap().headMap(toKey, inclusive));
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        this.processQueue();
        return new NavigableView(this, this.getRefMap().tailMap(fromKey, inclusive));
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        this.processQueue();
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    protected static class NavigableView<K, V>
    extends AbstractWeakValueNavigableMap<K, V> {
        protected final AbstractWeakValueNavigableMap<K, V> map;
        protected final NavigableMap<K, AbstractWeakValueMap.WeakValueRef<K, V>> mod;

        public NavigableView(AbstractWeakValueNavigableMap<K, V> map, NavigableMap<K, AbstractWeakValueMap.WeakValueRef<K, V>> sub) {
            this.map = map;
            this.mod = Collections.unmodifiableNavigableMap(sub);
        }

        @Override
        protected NavigableMap<K, AbstractWeakValueMap.WeakValueRef<K, V>> getRefMap() {
            this.map.processQueue();
            return this.mod;
        }
    }
}

