/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.connection.tree;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.TraceRmiConnectionManagerProvider;
import ghidra.app.plugin.core.debug.gui.tracermi.connection.tree.AbstractTraceRmiManagerNode;
import ghidra.app.services.TraceRmiService;
import javax.swing.Icon;

public class TraceRmiServerNode
extends AbstractTraceRmiManagerNode {
    private static final Icon ICON = DebuggerResources.ICON_THREAD;

    public TraceRmiServerNode(TraceRmiConnectionManagerProvider provider) {
        super(provider, "Server");
    }

    public Icon getIcon(boolean expanded) {
        return ICON;
    }

    public String getDisplayText() {
        TraceRmiService service = this.provider.getTraceRmiService();
        if (service == null) {
            return "<SERVICE MISSING>";
        }
        if (!service.isServerStarted()) {
            return "Server: CLOSED";
        }
        return "Server: LISTENING " + String.valueOf(service.getServerAddress());
    }

    public String getToolTip() {
        return this.getDisplayText();
    }

    public boolean isLeaf() {
        return true;
    }
}

