/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.table.GFilterTable;
import docking.widgets.table.RowObjectTableModel;
import generic.theme.GColor;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import ghidra.bitpatterns.gui.ByteSequenceTableModel;
import ghidra.bitpatterns.gui.FunctionBitPatternsExplorerPlugin;
import ghidra.bitpatterns.gui.PatternInfoRowObject;
import ghidra.bitpatterns.info.ByteSequenceRowObject;
import ghidra.bitpatterns.info.ContextRegisterFilter;
import ghidra.bitpatterns.info.PatternType;
import ghidra.util.HelpLocation;
import ghidra.util.bytesearch.DittedBitSequence;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public abstract class ByteSequenceAnalyzerProvider
extends DialogComponentProvider {
    private static final Color BG_DISABLED = new GColor("color.bg.uneditable");
    protected ByteSequenceTableModel byteSequenceTable;
    protected FunctionBitPatternsExplorerPlugin plugin;
    protected JPanel mainPanel;
    private JPanel infoPanel;
    private JTextField mergedSeqTextField;
    private JTextField bitsOfCheckField;
    private JTextField noteField;
    private DittedBitSequence merged;
    protected PatternType type;
    protected ContextRegisterFilter cRegFilter;
    protected String note;
    protected String title;
    private boolean mergedToSend = false;
    private DockingAction sendSelectedToClipboardAction;
    private DockingAction mergeAction;
    private DockingAction sendMergedToClipboardAction;

    public ByteSequenceAnalyzerProvider(String title, FunctionBitPatternsExplorerPlugin plugin, List<ByteSequenceRowObject> rowObjects, Component parent, PatternType type, ContextRegisterFilter cRegFilter, String note) {
        super(title, false, true, true, false);
        this.plugin = plugin;
        this.type = type;
        this.cRegFilter = cRegFilter;
        this.note = note;
        this.title = title;
        this.byteSequenceTable = this.createByteSequenceTable(plugin, rowObjects);
        this.infoPanel = this.createInfoPanel();
        this.mainPanel = this.createMainPanel();
        this.addWorkPanel(this.mainPanel);
        this.addCancelButton();
        this.addSendSelectedToClipboardAction();
        this.addMergeAction();
        this.addSendMergedToClipboardAction();
        this.cancelButton.setText("Dismiss");
        HelpLocation helpLocation = new HelpLocation("FunctionBitPatternsExplorerPlugin", "Analyzing_Byte_Sequences");
        this.setHelpLocation(helpLocation);
        this.setDefaultSize(1200, 800);
        DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)this);
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.infoPanel, "North");
        GFilterTable filterTable = new GFilterTable((RowObjectTableModel)this.byteSequenceTable);
        panel.add((Component)filterTable, "Center");
        panel.getAccessibleContext().setAccessibleName("Byte Sequence Analyzer");
        return panel;
    }

    private JPanel createInfoPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.mergedSeqTextField = new JTextField(60);
        this.mergedSeqTextField.setEditable(false);
        TitledBorder lubBorder = new TitledBorder("Merged Selections");
        this.mergedSeqTextField.setBorder(lubBorder);
        this.mergedSeqTextField.getAccessibleContext().setAccessibleName("Merged Selections");
        this.bitsOfCheckField = new JTextField(5);
        this.bitsOfCheckField.setEditable(false);
        TitledBorder bitsOfCheckBorder = new TitledBorder("Bits of Check");
        this.bitsOfCheckField.setBorder(bitsOfCheckBorder);
        this.bitsOfCheckField.getAccessibleContext().setAccessibleName("Bits of Check");
        this.noteField = new JTextField(60);
        this.noteField.setText(this.note);
        this.noteField.setEditable(true);
        TitledBorder noteBorder = new TitledBorder("Note");
        this.noteField.setBorder(noteBorder);
        this.noteField.getAccessibleContext().setAccessibleName("Note");
        panel.add((Component)this.mergedSeqTextField, "North");
        panel.add((Component)this.bitsOfCheckField, "Center");
        panel.add((Component)this.noteField, "South");
        panel.getAccessibleContext().setAccessibleName("Info");
        return panel;
    }

    private void addSendSelectedToClipboardAction() {
        this.sendSelectedToClipboardAction = new DockingAction("Send Selected to Clipboard", this.title){

            public void actionPerformed(ActionContext context) {
                List rows = ByteSequenceAnalyzerProvider.this.byteSequenceTable.getLastSelectedObjects();
                for (ByteSequenceRowObject row : rows) {
                    DittedBitSequence seq = new DittedBitSequence(row.getSequence(), true);
                    PatternInfoRowObject pattern = new PatternInfoRowObject(ByteSequenceAnalyzerProvider.this.type, seq, ByteSequenceAnalyzerProvider.this.cRegFilter);
                    pattern.setNote(row.getDisassembly());
                    ByteSequenceAnalyzerProvider.this.plugin.addPattern(pattern);
                }
                ByteSequenceAnalyzerProvider.this.plugin.updateClipboard();
            }

            public boolean isEnabledForContext(ActionContext context) {
                List rows = ByteSequenceAnalyzerProvider.this.byteSequenceTable.getLastSelectedObjects();
                if (rows == null) {
                    return false;
                }
                return !rows.isEmpty();
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        GIcon icon = new GIcon("icon.bytepatterns.send.to.clipboard");
        this.sendSelectedToClipboardAction.setPopupMenuData(new MenuData(new String[]{"Send Selected to Clipboard"}, (Icon)icon));
        this.sendSelectedToClipboardAction.setDescription("Creates patterns for the currently-selected strings of bytes and sends them to the clipboard");
        this.sendSelectedToClipboardAction.setHelpLocation(new HelpLocation("FunctionBitPatternsExplorerPlugin", "Analyzing_Byte_Sequences"));
        this.addAction((DockingActionIf)this.sendSelectedToClipboardAction);
    }

    private void addMergeAction() {
        this.mergeAction = new DockingAction("Merge Selected Rows", this.title){

            public void actionPerformed(ActionContext context) {
                ByteSequenceAnalyzerProvider.this.merged = ByteSequenceAnalyzerProvider.this.byteSequenceTable.mergeSelectedRows();
                if (ByteSequenceAnalyzerProvider.this.merged == null) {
                    return;
                }
                ByteSequenceAnalyzerProvider.this.mergedSeqTextField.setText(ByteSequenceAnalyzerProvider.this.merged.getHexString());
                ByteSequenceAnalyzerProvider.this.bitsOfCheckField.setText(Integer.toString(ByteSequenceAnalyzerProvider.this.merged.getNumFixedBits()));
                ByteSequenceAnalyzerProvider.this.mergedSeqTextField.setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
                ByteSequenceAnalyzerProvider.this.bitsOfCheckField.setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
                ByteSequenceAnalyzerProvider.this.noteField.setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
                ByteSequenceAnalyzerProvider.this.mergedToSend = true;
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }

            public boolean isEnabledForContext(ActionContext context) {
                return !ByteSequenceAnalyzerProvider.this.byteSequenceTable.getLastSelectedObjects().isEmpty();
            }
        };
        GIcon icon = new GIcon("icon.bytepatterns.byte.sequence.analyzer.merge");
        this.mergeAction.setPopupMenuData(new MenuData(new String[]{"Merge Selected Rows"}, (Icon)icon));
        this.mergeAction.setDescription("Merges the currently selected rows");
        this.mergeAction.setHelpLocation(new HelpLocation("FunctionBitPatternsExplorerPlugin", "Analyzing_Byte_Sequences"));
        this.addAction((DockingActionIf)this.mergeAction);
    }

    private void addSendMergedToClipboardAction() {
        this.sendMergedToClipboardAction = new DockingAction("Send Merged to Clipboard", this.title){

            public void actionPerformed(ActionContext context) {
                if (ByteSequenceAnalyzerProvider.this.merged != null) {
                    PatternInfoRowObject mergedInfo = new PatternInfoRowObject(ByteSequenceAnalyzerProvider.this.type, ByteSequenceAnalyzerProvider.this.merged, ByteSequenceAnalyzerProvider.this.cRegFilter);
                    ByteSequenceAnalyzerProvider.this.note = ByteSequenceAnalyzerProvider.this.noteField.getText();
                    mergedInfo.setNote(ByteSequenceAnalyzerProvider.this.note);
                    ByteSequenceAnalyzerProvider.this.plugin.addPattern(mergedInfo);
                    ByteSequenceAnalyzerProvider.this.plugin.updateClipboard();
                    ByteSequenceAnalyzerProvider.this.mergedSeqTextField.setBackground(BG_DISABLED);
                    ByteSequenceAnalyzerProvider.this.bitsOfCheckField.setBackground(BG_DISABLED);
                    ByteSequenceAnalyzerProvider.this.noteField.setBackground(BG_DISABLED);
                    ByteSequenceAnalyzerProvider.this.mergedToSend = false;
                }
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }

            public boolean isEnabledForContext(ActionContext context) {
                return ByteSequenceAnalyzerProvider.this.mergedToSend;
            }
        };
        GIcon icon = new GIcon("icon.bytepatterns.byte.sequence.analyzer.clipboard.merged");
        this.sendMergedToClipboardAction.setPopupMenuData(new MenuData(new String[]{"Send Merged to Clipboard"}, (Icon)icon));
        this.sendMergedToClipboardAction.setDescription("Sends the Merge Patterns to the Clipboard");
        this.sendMergedToClipboardAction.setHelpLocation(new HelpLocation("FunctionBitPatternsExplorerPlugin", "Analyzing_Byte_Sequences"));
        this.addAction((DockingActionIf)this.sendMergedToClipboardAction);
    }

    abstract ByteSequenceTableModel createByteSequenceTable(FunctionBitPatternsExplorerPlugin var1, List<ByteSequenceRowObject> var2);
}

