/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.util;

import java.util.function.Function;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.util.DimensionSummaryStatistics;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.jungrapht.visualization.layout.model.Dimension;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.jungrapht.visualization.layout.util.PropertyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialDimensionFunction<V>
implements Function<Graph<V, ?>, Pair<Integer>> {
    private static final Logger log = LoggerFactory.getLogger(InitialDimensionFunction.class);
    private static final Rectangle IDENTITY_SHAPE;
    private static final String INITIAL_DIMENSION_VERTEX_DENSITY = "jungrapht.initialDimensionVertexDensity";
    protected Function<V, Rectangle> vertexShapeFunction;
    protected float density;

    public static <V> Builder<V, ?, ?> builder() {
        return new Builder();
    }

    public static <V> Builder<V, ?, ?> builder(Function<V, Rectangle> vertexShapeFunction) {
        return new Builder(vertexShapeFunction);
    }

    public InitialDimensionFunction() {
        this(InitialDimensionFunction.builder());
    }

    InitialDimensionFunction(Builder<V, ?, ?> builder) {
        this(builder.vertexShapeFunction, builder.weight);
    }

    InitialDimensionFunction(Function<V, Rectangle> vertexShapeFunction, float density) {
        this.vertexShapeFunction = vertexShapeFunction;
        this.density = density;
    }

    public void setVertexShapeFunction(Function<V, Rectangle> vertexShapeFunction) {
        this.vertexShapeFunction = vertexShapeFunction;
    }

    public void setDensity(float density) {
        this.density = density;
    }

    @Override
    public Pair<Integer> apply(Graph<V, ?> graph) {
        DimensionSummaryStatistics dss = new DimensionSummaryStatistics();
        graph.vertexSet().stream().map(vertex -> this.vertexShapeFunction.apply(vertex)).forEach(dss::accept);
        Dimension average = dss.getAverage();
        int count = graph.vertexSet().size();
        int sqrt = (int)Math.sqrt(count);
        int larger = Math.max(average.width, average.height);
        larger *= sqrt;
        if (this.density > 0.0f) {
            larger = (int)((float)larger / this.density);
        }
        if (log.isTraceEnabled()) {
            log.trace("returning {} for graph with {} vertices", Pair.of(larger, larger), (Object)graph.vertexSet().size());
        }
        return Pair.of(larger, larger);
    }

    static {
        PropertyLoader.load();
        IDENTITY_SHAPE = Rectangle.of(-5, -5, 10, 10);
    }

    public static class Builder<V, T extends InitialDimensionFunction<V>, B extends Builder<V, T, B>> {
        protected Function<V, Rectangle> vertexShapeFunction = v -> IDENTITY_SHAPE;
        protected float weight = Float.parseFloat(System.getProperty("jungrapht.initialDimensionVertexDensity", "0.1f"));

        Builder(Function<V, Rectangle> vertexShapeFunction) {
            this.vertexShapeFunction = vertexShapeFunction;
        }

        Builder() {
        }

        public B vertexShapeFunction(Function<V, Rectangle> vertexShapeFunction) {
            this.vertexShapeFunction = vertexShapeFunction;
            return (B)this;
        }

        public B weight(float weight) {
            this.weight = weight;
            return (B)this;
        }

        public T build() {
            return (T)new InitialDimensionFunction(this);
        }
    }
}

