/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import docking.widgets.table.AbstractDynamicTableColumn;
import ghidra.app.plugin.core.codebrowser.AddressRangeInfo;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnitFormat;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.CodeUnitTableCellRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AddressRangeEndpointSettingsDefinition;
import ghidra.util.table.field.CodeUnitCountSettingsDefinition;
import ghidra.util.table.field.CodeUnitOffsetSettingsDefinition;
import ghidra.util.table.field.CodeUnitTableCellData;

public class AddressRangeCodeUnitTableColumn
extends AbstractDynamicTableColumn<AddressRangeInfo, CodeUnitTableCellData, Program> {
    private static SettingsDefinition[] SETTINGS = new SettingsDefinition[]{CodeUnitCountSettingsDefinition.DEF, CodeUnitOffsetSettingsDefinition.DEF, AddressRangeEndpointSettingsDefinition.DEF};
    private final CodeUnitTableCellRenderer renderer = new CodeUnitTableCellRenderer();
    private CodeUnitFormat codeUnitFormat;
    private static final String COLUMN_NAME = "Code Unit";

    public String getColumnName() {
        return COLUMN_NAME;
    }

    public String getColumnDisplayName(Settings settings) {
        String offset;
        StringBuilder sb = new StringBuilder(AddressRangeEndpointSettingsDefinition.DEF.getValueString(settings));
        sb.append(" ").append(COLUMN_NAME);
        int previewCnt = CodeUnitCountSettingsDefinition.DEF.getCount(settings);
        if (previewCnt != 1) {
            sb.append("[");
            sb.append(previewCnt);
            sb.append("]");
        }
        if (!"0".equals(offset = CodeUnitOffsetSettingsDefinition.DEF.getDisplayValue(settings))) {
            sb.append(offset);
        }
        return sb.toString();
    }

    public CodeUnitTableCellData getValue(AddressRangeInfo rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        int choice = AddressRangeEndpointSettingsDefinition.DEF.getChoice(settings);
        Address base = choice == 0 ? rowObject.min() : rowObject.max();
        ProgramLocation location = new ProgramLocation(program, base);
        return new CodeUnitTableCellData(location, this.getCodeUnitFormat(serviceProvider), CodeUnitOffsetSettingsDefinition.DEF.getOffset(settings), CodeUnitCountSettingsDefinition.DEF.getCount(settings));
    }

    public GColumnRenderer<CodeUnitTableCellData> getColumnRenderer() {
        return this.renderer;
    }

    public SettingsDefinition[] getSettingsDefinitions() {
        return SETTINGS;
    }

    public int getMaxLines(Settings settings) {
        return CodeUnitCountSettingsDefinition.DEF.getCount(settings);
    }

    private CodeUnitFormat getCodeUnitFormat(ServiceProvider serviceProvider) {
        if (this.codeUnitFormat == null) {
            this.codeUnitFormat = new BrowserCodeUnitFormat(serviceProvider);
        }
        return this.codeUnitFormat;
    }
}

