/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.commentwindow;

import docking.ActionContext;
import docking.ComponentProvider;
import ghidra.app.plugin.core.commentwindow.CommentRowObject;
import ghidra.app.plugin.core.commentwindow.CommentTableModel;
import ghidra.app.plugin.core.commentwindow.CommentWindowContext;
import ghidra.app.plugin.core.commentwindow.CommentWindowPlugin;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;

class CommentWindowProvider
extends ComponentProviderAdapter {
    private CommentWindowPlugin plugin;
    private GhidraThreadedTablePanel<CommentRowObject> threadedTablePanel;
    private GhidraTableFilterPanel<CommentRowObject> filterPanel;
    private JComponent mainPanel;
    private GhidraTable commentTable;
    private CommentTableModel commentModel;

    CommentWindowProvider(CommentWindowPlugin plugin) {
        super(plugin.getTool(), "Comment Window", plugin.getName());
        this.setTitle("Comments");
        this.plugin = plugin;
        this.mainPanel = this.createWorkPanel();
        this.tool.addComponentProvider((ComponentProvider)this, false);
    }

    public void componentHidden() {
        this.commentModel.reload(null);
    }

    public void componentShown() {
        this.commentModel.reload(this.plugin.getProgram());
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new CommentWindowContext(this, this.commentTable);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation(this.plugin.getName(), this.plugin.getName());
    }

    void programOpened(Program program) {
        if (this.isVisible()) {
            this.commentModel.reload(program);
        }
    }

    void programClosed() {
        if (this.isVisible()) {
            this.commentModel.reload(null);
        }
    }

    void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this);
        this.threadedTablePanel.dispose();
        this.filterPanel.dispose();
    }

    private JComponent createWorkPanel() {
        this.commentModel = new CommentTableModel(this.plugin);
        this.threadedTablePanel = new GhidraThreadedTablePanel<CommentRowObject>(this.commentModel, 1000);
        this.commentTable = this.threadedTablePanel.getTable();
        this.commentTable.getAccessibleContext().setAccessibleName("Comment Table");
        this.commentTable.setAutoLookupColumn(1);
        this.commentTable.setPreferredScrollableViewportSize(new Dimension(600, 400));
        this.commentTable.setRowSelectionAllowed(true);
        this.commentTable.setSelectionMode(2);
        this.commentTable.getSelectionModel().addListSelectionListener(e -> this.notifyContextChanged());
        this.commentModel.addTableModelListener(e -> {
            int rowCount = this.commentModel.getRowCount();
            int unfilteredCount = this.commentModel.getUnfilteredRowCount();
            StringBuilder buffy = new StringBuilder();
            buffy.append(rowCount).append(" items");
            if (rowCount != unfilteredCount) {
                buffy.append(" (of ").append(unfilteredCount).append(" )");
            }
            this.setSubTitle(buffy.toString());
        });
        this.commentTable.installNavigation((ServiceProvider)this.tool);
        JTableHeader commentHeader = this.commentTable.getTableHeader();
        commentHeader.setUpdateTableInRealTime(true);
        this.filterPanel = new GhidraTableFilterPanel((JTable)((Object)this.commentTable), this.commentModel);
        this.commentTable.getModel();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)this.threadedTablePanel), "Center");
        panel.add((Component)((Object)this.filterPanel), "South");
        String namePrefix = "Comments";
        this.commentTable.setAccessibleNamePrefix(namePrefix);
        this.filterPanel.setAccessibleNamePrefix(namePrefix);
        return panel;
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    void reload() {
        if (this.isVisible()) {
            this.commentModel.reload(this.plugin.getProgram());
        }
    }

    void commentAdded(Address address, CommentType commentType) {
        if (this.isVisible()) {
            this.commentModel.commentAdded(address, commentType);
        }
    }

    void commentRemoved(Address address, CommentType commentType) {
        if (this.isVisible()) {
            this.commentModel.commentRemoved(address, commentType);
        }
    }

    public GhidraTable getTable() {
        return this.commentTable;
    }
}

