/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.util;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeState;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataTypeTreeDeleteTask
extends Task {
    private static final int NODE_COUNT_FOR_COLLAPSING_TREE = 100;
    private Map<ArchiveNode, List<GTreeNode>> nodesByArchive;
    private DataTypeManagerPlugin plugin;
    private int nodeCount;

    public DataTypeTreeDeleteTask(DataTypeManagerPlugin plugin, List<GTreeNode> nodes) {
        super("Delete Nodes", true, true, true);
        this.plugin = plugin;
        this.nodeCount = nodes.size();
        nodes = this.filterList(nodes);
        this.nodesByArchive = this.groupNodeByArchive(nodes);
    }

    private Map<ArchiveNode, List<GTreeNode>> groupNodeByArchive(List<GTreeNode> nodes) {
        HashMap<ArchiveNode, List<GTreeNode>> archiveNodeMap = new HashMap<ArchiveNode, List<GTreeNode>>();
        for (GTreeNode node : nodes) {
            ArchiveNode archiveNode = ((DataTypeTreeNode)node).getArchiveNode();
            ArrayList<GTreeNode> archiveNodeList = (ArrayList<GTreeNode>)archiveNodeMap.get((Object)archiveNode);
            if (archiveNodeList == null) {
                archiveNodeList = new ArrayList<GTreeNode>();
                archiveNodeMap.put(archiveNode, archiveNodeList);
            }
            archiveNodeList.add(node);
        }
        return archiveNodeMap;
    }

    private List<GTreeNode> filterList(List<GTreeNode> nodeList) {
        HashSet<GTreeNode> nodeSet = new HashSet<GTreeNode>(nodeList);
        ArrayList<GTreeNode> filteredList = new ArrayList<GTreeNode>();
        for (GTreeNode node : nodeSet) {
            if (this.containsAncestor(nodeSet, node)) continue;
            filteredList.add(node);
        }
        return filteredList;
    }

    private boolean containsAncestor(Set<GTreeNode> nodeSet, GTreeNode node) {
        GTreeNode parent = node.getParent();
        if (parent == null) {
            return false;
        }
        if (nodeSet.contains(parent)) {
            return true;
        }
        return this.containsAncestor(nodeSet, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        int total = 0;
        for (List<GTreeNode> list : this.nodesByArchive.values()) {
            total += list.size();
        }
        monitor.initialize((long)total);
        DataTypesProvider provider = this.plugin.getProvider();
        DataTypeArchiveGTree tree = provider.getGTree();
        GTreeState treeState = tree.getTreeState();
        try {
            if (this.nodeCount > 100) {
                this.collapseArchives(tree);
            }
            Set<Map.Entry<ArchiveNode, List<GTreeNode>>> entries = this.nodesByArchive.entrySet();
            for (Map.Entry<ArchiveNode, List<GTreeNode>> entry : entries) {
                List<GTreeNode> list = entry.getValue();
                ArchiveNode node = entry.getKey();
                this.deleteNodes(node, list, monitor);
            }
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            tree.restoreTreeState(treeState);
        }
    }

    private void collapseArchives(DataTypeArchiveGTree tree) {
        GTreeNode root = tree.getModelRoot();
        List children = root.getChildren();
        for (GTreeNode archive : children) {
            tree.collapseAll(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNodes(ArchiveNode archiveNode, List<GTreeNode> list, TaskMonitor monitor) throws CancelledException {
        Archive archive = archiveNode.getArchive();
        DataTypeManager dataTypeManager = archive.getDataTypeManager();
        int transactionID = dataTypeManager.startTransaction("Delete Category/DataType");
        try {
            for (GTreeNode node : list) {
                monitor.checkCancelled();
                this.removeNode(node, monitor);
                monitor.incrementProgress(1L);
            }
        }
        finally {
            dataTypeManager.endTransaction(transactionID, true);
        }
    }

    private void removeNode(GTreeNode node, TaskMonitor monitor) {
        if (node instanceof DataTypeNode) {
            DataTypeNode dataTypeNode = (DataTypeNode)node;
            DataType dataType = dataTypeNode.getDataType();
            DataTypeManager dataTypeManager = dataType.getDataTypeManager();
            dataTypeManager.remove(dataType, monitor);
        } else {
            CategoryNode categoryNode = (CategoryNode)node;
            Category category = categoryNode.getCategory();
            category.getParent().removeCategory(category.getName(), monitor);
        }
    }
}

