/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.MenuData;
import ghidra.app.cmd.function.SetFunctionVarArgsCommand;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;

public class AddVarArgsAction
extends ListingContextAction {
    FunctionPlugin functionPlugin;

    AddVarArgsAction(FunctionPlugin plugin) {
        super("Add VarArgs", plugin.getName());
        this.functionPlugin = plugin;
        this.updatePopupMenu(true);
        this.setHelpLocation(new HelpLocation("FunctionPlugin", "Add_VarArgs"));
    }

    private void updatePopupMenu(boolean isSignatureAction) {
        if (isSignatureAction) {
            this.setPopupMenuData(new MenuData(new String[]{"Function", "Add VarArgs"}, null, "Function"));
        } else {
            this.setPopupMenuData(new MenuData(new String[]{"Function Variables", "Add VarArgs"}, null, "FunctionVariable"));
        }
    }

    @Override
    protected void actionPerformed(ListingActionContext context) {
        Function function;
        ProgramLocation loc = context.getLocation();
        if ((loc instanceof FunctionSignatureFieldLocation || loc instanceof VariableLocation) && (function = this.functionPlugin.getFunction(context)) != null && !function.hasVarArgs()) {
            Program program;
            SetFunctionVarArgsCommand command = new SetFunctionVarArgsCommand(function, true);
            PluginTool tool = this.functionPlugin.getTool();
            if (!tool.execute((Command)command, (DomainObject)(program = context.getProgram()))) {
                tool.setStatusInfo("Unable to add function varArgs on function: " + function.getName());
            }
        }
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection()) {
            return false;
        }
        ProgramLocation loc = context.getLocation();
        if (!(loc instanceof VariableLocation) && !(loc instanceof FunctionSignatureFieldLocation)) {
            return false;
        }
        if (loc instanceof FunctionSignatureFieldLocation) {
            this.updatePopupMenu(true);
        } else {
            this.updatePopupMenu(false);
        }
        Function function = this.functionPlugin.getFunction(context);
        return function != null && !function.hasVarArgs();
    }
}

