/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.widgets.combobox.GhidraComboBox;
import ghidra.app.plugin.core.function.editor.VarnodeType;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

class VarnodeTypeCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JComboBox<?> combo;
    private JTable jTable;
    private int editRow;
    private int editCol;

    VarnodeTypeCellEditor() {
    }

    @Override
    public Object getCellEditorValue() {
        return this.combo.getSelectedItem();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() > 1;
        }
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.jTable = table;
        this.editRow = row;
        this.editCol = column;
        this.combo = new GhidraComboBox(new Object[]{VarnodeType.Register, VarnodeType.Stack, VarnodeType.Memory});
        this.combo.setSelectedItem(value);
        this.combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VarnodeTypeCellEditor.this.stopCellEditing();
                VarnodeTypeCellEditor.this.jTable.editCellAt(VarnodeTypeCellEditor.this.editRow, VarnodeTypeCellEditor.this.editCol + 1);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VarnodeTypeCellEditor.this.combo.showPopup();
                VarnodeTypeCellEditor.this.combo.requestFocus();
            }
        });
        return this.combo;
    }
}

