/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.osgi;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.osgi.BundleHost;
import ghidra.app.plugin.core.osgi.GhidraBundleException;
import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;

public abstract class GhidraBundle {
    protected final ResourceFile bundleFile;
    protected final BundleHost bundleHost;
    protected boolean enabled;
    protected boolean systemBundle;

    GhidraBundle(BundleHost bundleHost, ResourceFile bundleFile, boolean enabled, boolean systemBundle) {
        this.bundleHost = bundleHost;
        this.bundleFile = bundleFile;
        this.enabled = enabled;
        this.systemBundle = systemBundle;
    }

    abstract boolean clean();

    public abstract boolean build(PrintWriter var1) throws Exception;

    public boolean build() throws Exception {
        return this.build(new PrintWriter(System.err));
    }

    public abstract String getLocationIdentifier();

    public abstract List<BundleRequirement> getAllRequirements() throws GhidraBundleException;

    public abstract List<BundleCapability> getAllCapabilities() throws GhidraBundleException;

    public ResourceFile getFile() {
        return this.bundleFile;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isSystemBundle() {
        return this.systemBundle;
    }

    static Type getType(ResourceFile file) {
        if (file.isDirectory()) {
            return Type.SOURCE_DIR;
        }
        String fileName = file.getName().toLowerCase();
        if (fileName.endsWith(".bnd")) {
            return Type.BND_SCRIPT;
        }
        if (fileName.endsWith(".jar")) {
            return Type.JAR;
        }
        return Type.INVALID;
    }

    public static Type getType(File file) {
        if (file.isDirectory()) {
            return Type.SOURCE_DIR;
        }
        String fileName = file.getName().toLowerCase();
        if (fileName.endsWith(".bnd")) {
            return Type.BND_SCRIPT;
        }
        if (fileName.endsWith(".jar")) {
            return Type.JAR;
        }
        return Type.INVALID;
    }

    public Bundle getOSGiBundle() {
        return this.bundleHost.getOSGiBundle(this.getLocationIdentifier());
    }

    public boolean isActive() {
        Bundle bundle = this.getOSGiBundle();
        return bundle != null && bundle.getState() == 32;
    }

    public String toString() {
        Bundle bundle = this.getOSGiBundle();
        return bundle != null ? bundle.getSymbolicName() : this.bundleFile.toString();
    }

    static enum Type {
        BND_SCRIPT,
        JAR,
        SOURCE_DIR,
        INVALID;

    }
}

