/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.KeyBindingPrecedence;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeDragNDropHandler;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.SymbolTreeProvider;
import ghidra.app.plugin.core.symboltree.actions.SymbolTreeContextAction;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeNode;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import resources.Icons;

public class PasteAction
extends SymbolTreeContextAction {
    private static final Icon PASTE_ICON = Icons.PASTE_ICON;

    public PasteAction(SymbolTreePlugin plugin, SymbolTreeProvider provider) {
        super("Paste Symbols", plugin.getName());
        this.setPopupMenuData(new MenuData(new String[]{"Paste"}, PASTE_ICON, "cut/paste"));
        this.setKeyBindingData(new KeyBindingData(KeyStroke.getKeyStroke(86, 128), KeyBindingPrecedence.ActionMapLevel));
    }

    @Override
    public boolean isAddToPopup(SymbolTreeActionContext context) {
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        return selectionPaths.length > 0;
    }

    @Override
    public boolean isEnabledForContext(SymbolTreeActionContext context) {
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        if (selectionPaths.length != 1) {
            return false;
        }
        Object pathComponent = selectionPaths[0].getLastPathComponent();
        if (!(pathComponent instanceof SymbolTreeNode)) {
            return false;
        }
        SymbolTreeNode node = (SymbolTreeNode)((Object)pathComponent);
        Clipboard clipboard = context.getSymbolTreeProvider().getClipboard();
        Transferable transferable = clipboard.getContents((Object)this);
        if (transferable == null) {
            return false;
        }
        return node.supportsDataFlavors(transferable.getTransferDataFlavors());
    }

    @Override
    public void actionPerformed(SymbolTreeActionContext context) {
        TreePath path = context.getSelectedPath();
        if (path == null) {
            return;
        }
        GTreeNode destinationNode = (GTreeNode)path.getLastPathComponent();
        Clipboard clipboard = context.getSymbolTreeProvider().getClipboard();
        Transferable transferable = clipboard.getContents((Object)this);
        if (transferable == null) {
            return;
        }
        GTreeDragNDropHandler dragNDropHandler = context.getSymbolTree().getDragNDropHandler();
        dragNDropHandler.drop(destinationNode, transferable, 2);
        clipboard.setContents(null, null);
    }
}

