/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import generic.jar.ResourceFile;
import ghidra.util.Msg;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.Set;

public class GhidraScriptProperties {
    private HashMap<String, String> propertiesMap = new HashMap();
    private String baseName;

    GhidraScriptProperties() {
    }

    protected void loadGhidraScriptProperties(ResourceFile scriptLocation, String newBaseName) throws IOException {
        this.baseName = newBaseName;
        if (scriptLocation.isDirectory()) {
            String propFileName = newBaseName + ".properties";
            ResourceFile[] childFiles = scriptLocation.listFiles();
            ResourceFile propFile = null;
            for (ResourceFile chFile : childFiles) {
                if (!chFile.getName().equals(propFileName)) continue;
                propFile = chFile;
                break;
            }
            if (propFile != null) {
                this.loadGhidraScriptProperties(propFile);
            }
        } else {
            Msg.warn((Object)this, (Object)("The path '" + scriptLocation.toString() + "' is not a valid directory."));
        }
    }

    public String getFilename() {
        return this.baseName + ".properties";
    }

    protected void loadGhidraScriptProperties(List<ResourceFile> possibleLocations, String newBaseName) throws IOException {
        for (ResourceFile location : possibleLocations) {
            this.loadGhidraScriptProperties(location, newBaseName);
            if (this.isEmpty()) continue;
            break;
        }
    }

    protected void loadGhidraScriptProperties(ResourceFile file) throws IOException {
        Msg.info((Object)this, (Object)("Reading script properties file: " + file.getAbsolutePath()));
        if (!file.isFile()) {
            Msg.warn((Object)this, (Object)(".properties file '" + file.toString() + "' is not a valid file."));
            return;
        }
        try (Scanner scanner = new Scanner(file.getInputStream(), "ASCII");){
            while (scanner.hasNextLine()) {
                int equalsIndex;
                String line = scanner.nextLine().trim();
                if (line.startsWith("#") || line.startsWith("!") || line.isEmpty() || (equalsIndex = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, equalsIndex).trim();
                String value = line.substring(equalsIndex + 1).trim();
                this.propertiesMap.put(key, value);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException("Could not find .properties file '" + file.toString() + "'");
        }
    }

    protected String put(String key, String value) {
        return this.propertiesMap.put(key.trim(), value);
    }

    public String getValue(String keyString) {
        if (this.propertiesMap.size() == 0) {
            return "";
        }
        if (this.propertiesMap.containsKey(keyString)) {
            return this.propertiesMap.get(keyString);
        }
        return "";
    }

    public boolean isEmpty() {
        return this.propertiesMap.size() == 0;
    }

    protected String remove(String keyString) {
        return this.propertiesMap.remove(keyString);
    }

    protected void clearProperties() {
        this.propertiesMap.clear();
    }

    public boolean containsKey(String keyString) {
        return this.propertiesMap.containsKey(keyString);
    }

    public boolean containsValue(String valueString) {
        return this.propertiesMap.containsValue(valueString);
    }

    public Set<String> keySet() {
        return this.propertiesMap.keySet();
    }

    protected Collection<String> values() {
        return this.propertiesMap.values();
    }
}

