/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.util.InvalidNameException;

public class DataTypeNamingUtil {
    private static final String ANONYMOUS_FUNCTION_DEF_PREFIX = "_func";

    private DataTypeNamingUtil() {
    }

    public static String setMangledAnonymousFunctionName(FunctionDefinitionDataType functionDefinition) {
        String name = DataTypeNamingUtil.generateMangledSignature(functionDefinition);
        try {
            functionDefinition.setName(name);
        }
        catch (InvalidNameException e) {
            throw new AssertionError((Object)e);
        }
        return name;
    }

    public static String generateMangledSignature(FunctionDefinitionDataType functionDefinition) {
        String name;
        String convention;
        DataType returnType = functionDefinition.getReturnType();
        ParameterDefinition[] parameters = functionDefinition.getArguments();
        StringBuilder sb = new StringBuilder(ANONYMOUS_FUNCTION_DEF_PREFIX);
        if (functionDefinition.hasNoReturn()) {
            sb.append("_").append("noreturn");
        }
        if (!"unknown".equals(convention = functionDefinition.getCallingConventionName())) {
            sb.append("_").append(convention);
        }
        sb.append("_");
        sb.append(DataTypeNamingUtil.mangleDTName(returnType));
        for (ParameterDefinition p : parameters) {
            sb.append("_").append(DataTypeNamingUtil.mangleDTName(p.getDataType()));
        }
        if (functionDefinition.hasVarArgs()) {
            sb.append("_").append("varargs");
        }
        if (!DataUtilities.isValidDataTypeName((String)(name = sb.toString()))) {
            throw new AssertionError((Object)("Unexpected bad name: " + name));
        }
        return name;
    }

    private static String mangleDTName(DataType dt) {
        String name = DataTypeUtilities.getNameWithoutConflict((DataType)dt);
        return name.replaceAll(" ", "_").replaceAll("\\*", "ptr");
    }
}

