/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.formats.gfilesystem.FSRL;
import java.io.IOException;

public class UnlimitedByteProviderWrapper
extends ByteProviderWrapper {
    public UnlimitedByteProviderWrapper(ByteProvider provider) throws IOException {
        this(provider, 0L, provider.length(), provider.getFSRL());
    }

    public UnlimitedByteProviderWrapper(ByteProvider provider, FSRL fsrl) throws IOException {
        this(provider, 0L, provider.length(), fsrl);
    }

    public UnlimitedByteProviderWrapper(ByteProvider provider, long subOffset, long subLength) {
        this(provider, subOffset, subLength, null);
    }

    public UnlimitedByteProviderWrapper(ByteProvider provider, long subOffset, long subLength, FSRL fsrl) {
        super(provider, subOffset, subLength, fsrl);
    }

    @Override
    public boolean isValidIndex(long index) {
        return index >= 0L;
    }

    @Override
    public byte readByte(long index) throws IOException {
        if (index < 0L) {
            throw new IOException("Invalid index: " + index);
        }
        if (index >= this.subLength) {
            return 0;
        }
        return this.provider.readByte(this.subOffset + index);
    }

    @Override
    public byte[] readBytes(long index, long length) throws IOException {
        if (index < 0L) {
            throw new IOException("Invalid index: " + index);
        }
        if (index >= this.subLength) {
            return new byte[(int)length];
        }
        if (index + length > this.subLength) {
            byte[] bytes = new byte[(int)length];
            byte[] partialBytes = this.provider.readBytes(this.subOffset + index, this.subLength - index);
            System.arraycopy(partialBytes, 0, bytes, 0, partialBytes.length);
            return bytes;
        }
        return this.provider.readBytes(this.subOffset + index, length);
    }
}

