/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

public class DWARFRange
implements Comparable<DWARFRange> {
    public static final DWARFRange EMPTY = new DWARFRange(0L, 0L);
    private final long start;
    private final long end;

    public DWARFRange(long start, long end) {
        if (Long.compareUnsigned(end, start) < 0) {
            throw new IllegalArgumentException("Range max (%x) cannot be less than min (%x).".formatted(end, start));
        }
        this.start = start;
        this.end = end;
    }

    public String toString() {
        return "[%x,%x)".formatted(this.start, this.end);
    }

    @Override
    public int compareTo(DWARFRange other) {
        int tmp = Long.compareUnsigned(this.start, other.start);
        if (tmp == 0) {
            tmp = Long.compareUnsigned(this.end, other.end);
        }
        return tmp;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public boolean contains(long addr) {
        return Long.compareUnsigned(this.start, addr) <= 0 && Long.compareUnsigned(addr, this.end) < 0;
    }

    public long getFrom() {
        return this.start;
    }

    public long getTo() {
        return this.end;
    }
}

