/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoTypeManager;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.viewer.field.AddressAnnotatedStringHandler;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypedefDataType;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.Set;

@StructureMapping(structureName={"runtime.maptype", "internal/abi.MapType"})
public class GoMapType
extends GoType {
    @FieldMapping
    @MarkupReference(value="getKey")
    private long key;
    @FieldMapping
    @MarkupReference(value="getElement")
    private long elem;
    @FieldMapping
    @MarkupReference(value="getBucket")
    private long bucket;
    @FieldMapping
    private long hasher;
    @FieldMapping
    private int keysize;
    @FieldMapping(fieldName={"elemsize", "ValueSize"})
    private int elemsize;
    @FieldMapping
    private int bucketsize;
    @FieldMapping
    private int flags;

    @Markup
    public GoType getKey() throws IOException {
        return this.programContext.getGoTypes().getType(this.key);
    }

    @Markup
    public GoType getElement() throws IOException {
        return this.programContext.getGoTypes().getType(this.elem);
    }

    @Markup
    public GoType getBucket() throws IOException {
        return this.programContext.getGoTypes().getType(this.bucket);
    }

    @Override
    public DataType recoverDataType(GoTypeManager goTypes) throws IOException {
        GoType mapGoType = goTypes.getMapGoType();
        if (mapGoType == null) {
            return goTypes.getVoidPtrDT();
        }
        DataType mapDT = goTypes.getGhidraDataType(mapGoType);
        Pointer ptrMapDt = goTypes.getDTM().getPointer(mapDT);
        if (this.typ.getSize() != (long)ptrMapDt.getLength()) {
            Msg.warn((Object)this, (Object)"Size mismatch between map type and recovered type");
        }
        TypedefDataType typedef = new TypedefDataType(goTypes.getCP(this), goTypes.getTypeName(this), (DataType)ptrMapDt, goTypes.getDTM());
        return typedef;
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        GoType keyType = this.getKey();
        GoType elemType = this.getElement();
        GoType bucketType = this.getBucket();
        if (keyType != null) {
            keyType.discoverGoTypes(discoveredTypes);
        }
        if (elemType != null) {
            elemType.discoverGoTypes(discoveredTypes);
        }
        if (bucketType != null) {
            bucketType.discoverGoTypes(discoveredTypes);
        }
        return true;
    }

    @Override
    protected String getTypeDeclString() throws IOException {
        String selfName = this.getName();
        String keyName = this.getKey().getName();
        String elemName = this.getElement().getName();
        String defStr = "map[%s]%s".formatted(keyName, elemName);
        String defStrWithLinks = "map[%s]%s".formatted(AddressAnnotatedStringHandler.createAddressAnnotationString(this.key, keyName), AddressAnnotatedStringHandler.createAddressAnnotationString(this.elem, elemName));
        boolean hasName = !defStr.equals(selfName);
        return "type %s%s".formatted(hasName ? selfName + " " : "", defStrWithLinks);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.typ.getSize() == (long)this.programContext.getPtrSize();
    }
}

