/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class DyldSubcacheEntry
implements StructConverter {
    private byte[] uuid;
    private long cacheVMOffset;
    private byte[] cacheExtension;

    public DyldSubcacheEntry(BinaryReader reader) throws IOException {
        this.uuid = reader.readNextByteArray(16);
        this.cacheVMOffset = reader.readNextLong();
        if (reader.readByte(reader.getPointerIndex()) == 46) {
            this.cacheExtension = reader.readNextByteArray(32);
        }
    }

    public String getUuid() {
        return NumericUtilities.convertBytesToString((byte[])this.uuid);
    }

    public long getCacheVMOffset() {
        return this.cacheVMOffset;
    }

    public String getCacheExtension() {
        int i;
        if (this.cacheExtension == null) {
            return null;
        }
        for (i = 0; i < this.cacheExtension.length && this.cacheExtension[i] != 0; ++i) {
        }
        return new String(this.cacheExtension, 0, i, StandardCharsets.US_ASCII);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_subcache_entry", 0);
        struct.add((DataType)new ArrayDataType(BYTE, 16, 1), "uuid", "The UUID of the subCache file");
        struct.add(QWORD, "cacheVMOffset", "The offset of this subcache from the main cache base address");
        if (this.cacheExtension != null) {
            struct.add((DataType)new ArrayDataType(ASCII, 32, 1), "cacheExtension", "The extension of the subCache file");
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

