/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfString;
import ghidra.app.util.bin.format.omf.OmfUtils;
import ghidra.app.util.bin.format.omf.omf.OmfRecordTypes;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class OmfCommentRecord
extends OmfRecord {
    public static final byte COMMENT_CLASS_TRANSLATOR = 0;
    public static final byte COMMENT_CLASS_LIBMOD = -93;
    public static final byte COMMENT_CLASS_DEFAULT_LIBRARY = -97;
    public static final byte COMMENT_CLASS_WATCOM_SETTINGS = -101;
    public static final byte COMMENT_CLASS_MICROSOFT_SETTINGS = -99;
    private byte commentType;
    private byte commentClass;
    private OmfString value;

    public OmfCommentRecord(BinaryReader reader) throws IOException {
        super(reader);
    }

    @Override
    public void parseData() throws IOException, OmfException {
        this.commentType = this.dataReader.readNextByte();
        this.commentClass = this.dataReader.readNextByte();
        switch (this.commentClass) {
            case -97: 
            case 0: {
                byte[] bytes = this.dataReader.readNextByteArray(this.getRecordLength() - 3);
                this.value = new OmfString(bytes.length, new String(bytes, StandardCharsets.US_ASCII));
                break;
            }
            case -93: {
                this.value = OmfUtils.readString(this.dataReader);
                break;
            }
        }
    }

    public byte getCommentType() {
        return this.commentType;
    }

    public byte getCommentClass() {
        return this.commentClass;
    }

    public String getValue() {
        return this.value.str();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        int strlen = this.getRecordLength() - 3;
        StructureDataType struct = new StructureDataType(OmfRecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", "");
        struct.add(BYTE, "comment_type", null);
        struct.add(BYTE, "comment_class", null);
        if (strlen > 0) {
            struct.add((DataType)new StringDataType(), strlen, "str", null);
        }
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }
}

