/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.Omf2or4;
import ghidra.app.util.bin.format.omf.OmfIndex;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfString;
import ghidra.app.util.bin.format.omf.OmfUtils;
import ghidra.app.util.bin.format.omf.omf.OmfRecordTypes;
import ghidra.app.util.bin.format.omf.omf.OmfSymbol;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OmfSymbolRecord
extends OmfRecord {
    private OmfIndex baseGroupIndex;
    private OmfIndex baseSegmentIndex;
    private int baseFrame;
    private boolean isStatic;
    private OmfSymbol[] symbol;
    private List<Reference> refs = new ArrayList<Reference>();

    public OmfSymbolRecord(BinaryReader reader, boolean isStatic) throws IOException {
        super(reader);
        this.isStatic = isStatic;
    }

    @Override
    public void parseData() throws IOException {
        boolean hasBigFields = this.hasBigFields();
        this.baseGroupIndex = OmfUtils.readIndex(this.dataReader);
        this.baseSegmentIndex = OmfUtils.readIndex(this.dataReader);
        if (this.baseSegmentIndex.value() == 0) {
            this.baseFrame = this.dataReader.readNextUnsignedShort();
        }
        ArrayList<OmfSymbol> symbollist = new ArrayList<OmfSymbol>();
        while (this.dataReader.getPointerIndex() < this.dataEnd) {
            OmfString name = OmfUtils.readString(this.dataReader);
            Omf2or4 offset = OmfUtils.readInt2Or4(this.dataReader, hasBigFields);
            OmfIndex type = OmfUtils.readIndex(this.dataReader);
            OmfSymbol subrec = new OmfSymbol(name.str(), type.value(), offset.value(), 0, 0);
            symbollist.add(subrec);
            this.refs.add(new Reference(name, offset, type));
        }
        this.symbol = new OmfSymbol[symbollist.size()];
        symbollist.toArray(this.symbol);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public int getGroupIndex() {
        return this.baseGroupIndex.value();
    }

    public int getSegmentIndex() {
        return this.baseSegmentIndex.value();
    }

    public int numSymbols() {
        return this.symbol.length;
    }

    public OmfSymbol getSymbol(int i) {
        return this.symbol[i];
    }

    public List<OmfSymbol> getSymbols() {
        return List.of(this.symbol);
    }

    public int getBaseFrame() {
        return this.baseFrame;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(OmfRecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", null);
        struct.add(this.baseGroupIndex.toDataType(), "base_group_index", null);
        struct.add(this.baseSegmentIndex.toDataType(), "base_segment_index", null);
        if (this.baseSegmentIndex.value() == 0) {
            struct.add(WORD, "base_frame", null);
        }
        for (Reference ref : this.refs) {
            struct.add(ref.name.toDataType(), ref.name.getDataTypeSize(), "name", null);
            struct.add(ref.offset.toDataType(), "offset", null);
            struct.add(ref.type.toDataType(), "type", null);
        }
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }

    private record Reference(OmfString name, Omf2or4 offset, OmfIndex type) {
    }
}

