/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.app.util.DomainObjectService;
import ghidra.app.util.Option;
import ghidra.app.util.exporter.Exporter;
import ghidra.app.util.exporter.ExporterException;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.DataTypeArchiveDB;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class GdtExporter
extends Exporter {
    public static final String EXTENSION = "gdt";
    public static final String SUFFIX = ".gdt";
    public static final String NAME = "Ghidra Data Type Archive File";

    public GdtExporter() {
        super(NAME, EXTENSION, new HelpLocation("ExporterPlugin", EXTENSION));
    }

    @Override
    public boolean canExportDomainObject(Class<? extends DomainObject> domainObjectClass) {
        return DataTypeArchiveDB.class.isAssignableFrom(domainObjectClass);
    }

    @Override
    public boolean canExportDomainFile(DomainFile domainFile) {
        return this.canExportDomainObject(domainFile.getDomainObjectClass());
    }

    public boolean equals(Object obj) {
        return obj instanceof GdtExporter;
    }

    @Override
    public boolean export(File file, DomainObject domainObj, AddressSetView addrSet, TaskMonitor monitor) {
        try {
            file.delete();
            domainObj.saveToPackedFile(file, monitor);
        }
        catch (UnsupportedOperationException e) {
            this.log.appendMsg("Content does not support packed file export!");
            this.log.appendException((Throwable)e);
            return false;
        }
        catch (CancelledException ce) {
            return false;
        }
        catch (Exception e) {
            this.log.appendMsg("Unexpected exception exporting file: " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean export(File file, DomainFile domainFile, TaskMonitor monitor) throws ExporterException, IOException {
        if (!this.canExportDomainFile(domainFile)) {
            throw new UnsupportedOperationException("only DataTypeArchiveDB files are supported");
        }
        try {
            domainFile.packFile(file, monitor);
        }
        catch (CancelledException e) {
            return false;
        }
        catch (Exception e) {
            this.log.appendMsg("Unexpected exception exporting file: " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public List<Option> getOptions(DomainObjectService domainObjectService) {
        return EMPTY_OPTIONS;
    }

    @Override
    public void setOptions(List<Option> options) {
    }

    @Override
    public boolean supportsAddressRestrictedExport() {
        return false;
    }
}

