/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.html.PlaceHolderLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.VariableTextLine;
import java.awt.Color;

public class EmptyVariableTextLine
extends VariableTextLine
implements PlaceHolderLine {
    private int numberOfCharacters;

    public EmptyVariableTextLine(int numberOfCharacters) {
        super(EmptyVariableTextLine.buildDisplayText(numberOfCharacters >> 1), EmptyVariableTextLine.buildDisplayText(numberOfCharacters >> 1), null);
        this.numberOfCharacters = numberOfCharacters;
    }

    private static String buildDisplayText(int numberOfCharacters) {
        StringBuffer buffy = new StringBuffer("<TT>");
        for (int i = 0; i < numberOfCharacters; ++i) {
            buffy.append("&nbsp;");
        }
        buffy.append("</TT>");
        return buffy.toString();
    }

    @Override
    public ValidatableLine copy() {
        return new EmptyVariableTextLine(this.numberOfCharacters);
    }

    @Override
    public void updateColor(ValidatableLine otherValidatableLine, Color invalidColor) {
        if (invalidColor == null) {
            throw new NullPointerException("Color cannot be null");
        }
        if (otherValidatableLine == null || otherValidatableLine instanceof EmptyVariableTextLine) {
            return;
        }
        otherValidatableLine.setTextColor(invalidColor);
    }

    @Override
    public boolean matches(ValidatableLine otherValidatableLine) {
        return false;
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    boolean matchesName(String otherName) {
        return false;
    }

    @Override
    boolean matchesType(String otherType) {
        return false;
    }

    @Override
    public String toString() {
        return "<EmptyVariableTextLine>";
    }
}

