/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.AbstractOffsetFieldFactory;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.OffsetFieldType;

public class MemoryBlockOffsetFieldFactory
extends AbstractOffsetFieldFactory {
    private static final String FIELD_OFFSET_DESCRIPTION = "MemoryBlock";
    private static final String FIELD_NAME_DESCRIPTION = "Memory Block";

    public MemoryBlockOffsetFieldFactory() {
        super(FIELD_OFFSET_DESCRIPTION);
    }

    private MemoryBlockOffsetFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_OFFSET_DESCRIPTION, FIELD_NAME_DESCRIPTION, model, hlProvider, displayOptions, fieldOptions);
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider highlightProvider, ToolOptions options, ToolOptions fieldOptions) {
        return new MemoryBlockOffsetFieldFactory(formatModel, highlightProvider, (Options)options, (Options)fieldOptions);
    }

    @Override
    public String getOffsetValue(CodeUnit cu) {
        Address addr = cu.getAddress();
        String text = "";
        MemoryBlock block = cu.getProgram().getMemory().getBlock(addr);
        if (block != null) {
            long offset = addr.subtract(block.getStart());
            text = String.format(this.useHex ? "0x%x" : "%d", offset);
            if (this.showName) {
                text = "%s:%s".formatted(block.getName(), text);
            }
        }
        return text;
    }

    @Override
    public OffsetFieldType getOffsetFieldType() {
        return OffsetFieldType.MEMORYBLOCK;
    }
}

