/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FieldHeader;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.util.HelpLocation;

public class AddFieldAction
extends DockingAction {
    private FieldHeader panel;
    private final FieldFormatModel formatModel;
    private final FieldFactory myFieldFactory;

    public AddFieldAction(String owner, FieldFactory fieldFactory, FieldHeader panel, FieldFormatModel formatModel) {
        super(fieldFactory.getFieldName(), owner, false);
        this.myFieldFactory = fieldFactory;
        this.formatModel = formatModel;
        this.panel = panel;
        this.setPopupMenuData(new MenuData(new String[]{"Add Field", fieldFactory.getFieldName()}, "header b"));
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "Add Field"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        FieldFactory[] unusedFactories;
        if (!(context.getContextObject() instanceof FieldHeaderLocation)) {
            return false;
        }
        for (FieldFactory unusedFieldFactory : unusedFactories = this.formatModel.getUnusedFactories()) {
            if (unusedFieldFactory != this.myFieldFactory) continue;
            return true;
        }
        return false;
    }

    public boolean isValidContext(ActionContext context) {
        if (!(context.getContextObject() instanceof FieldHeaderLocation)) {
            return false;
        }
        FieldHeaderLocation loc = (FieldHeaderLocation)context.getContextObject();
        FieldFormatModel modelAtLocation = loc.getModel();
        return modelAtLocation == this.formatModel;
    }

    public void actionPerformed(ActionContext context) {
        FieldHeaderLocation loc = (FieldHeaderLocation)context.getContextObject();
        this.panel.setTabLock(true);
        this.formatModel.addFactory(this.myFieldFactory, loc.getRow(), loc.getColumn());
    }

    public String toString() {
        return "{\n\tfield: " + this.myFieldFactory.getFieldName() + "\n\tmodel: " + this.formatModel.getName() + "\n\towner: " + this.getOwner() + "\n}";
    }
}

