/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.items;

import ghidra.app.plugin.core.symboltree.SymbolTreeService;
import ghidra.features.base.quickfix.QuickFixStatus;
import ghidra.features.base.replace.RenameQuickFix;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.List;
import java.util.Map;

public class RenameSymbolQuickFix
extends RenameQuickFix {
    private Symbol symbol;

    public RenameSymbolQuickFix(Symbol symbol, String newName) {
        super(symbol.getProgram(), symbol.getName(), newName);
        this.symbol = symbol;
        this.performDuplicateCheck();
    }

    @Override
    public String getItemType() {
        return this.symbol.getSymbolType().toString();
    }

    private void performDuplicateCheck() {
        Namespace parentNamespace = this.symbol.getParentNamespace();
        SymbolTable symbolTable = this.program.getSymbolTable();
        List symbols = symbolTable.getSymbols(this.replacement, parentNamespace);
        if (!symbols.isEmpty()) {
            this.setStatus(QuickFixStatus.WARNING, "There is already a symbol named \"" + this.replacement + "\" in namespace \"" + parentNamespace.getName() + "\"");
        }
    }

    @Override
    public Address getAddress() {
        Address address = this.symbol.getAddress();
        if (address == Address.NO_ADDRESS) {
            address = null;
        }
        return address;
    }

    @Override
    public void statusChanged(QuickFixStatus newStatus) {
        if (newStatus == QuickFixStatus.NONE) {
            this.performDuplicateCheck();
        }
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return this.symbol.getProgramLocation();
    }

    @Override
    public String getPath() {
        Namespace namespace = this.symbol.getParentNamespace();
        return namespace.getName(true);
    }

    @Override
    public String doGetCurrent() {
        if (this.symbol.isDeleted()) {
            return null;
        }
        return this.symbol.getName();
    }

    @Override
    public void execute() {
        try {
            this.symbol.setName(this.replacement, SourceType.USER_DEFINED);
        }
        catch (DuplicateNameException | InvalidInputException e) {
            this.setStatus(QuickFixStatus.ERROR, "Rename Failed! " + e.getMessage());
        }
    }

    @Override
    public Map<String, String> getCustomToolTipData() {
        SymbolType symbolType = this.symbol.getSymbolType();
        Namespace parentNamespace = this.symbol.getParentNamespace();
        if (symbolType == SymbolType.PARAMETER || symbolType == SymbolType.LOCAL_VAR) {
            return Map.of("Function", parentNamespace.getName(true));
        }
        return Map.of("Namespace", parentNamespace.getName(false));
    }

    @Override
    protected boolean navigateSpecial(ServiceProvider services, boolean fromSelectionChange) {
        if (this.symbol.getAddress().isMemoryAddress()) {
            return false;
        }
        SymbolTreeService service = (SymbolTreeService)services.getService(SymbolTreeService.class);
        if (service != null) {
            service.selectSymbol(this.symbol);
            return true;
        }
        return false;
    }
}

