/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem.fileinfo;

import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import java.util.ArrayList;
import java.util.List;

public class FileAttributes {
    public static FileAttributes EMPTY = new FileAttributes(List.of());
    private List<FileAttribute<?>> attributes;

    public static FileAttributes of(FileAttribute<?> ... attribs) {
        FileAttributes result = new FileAttributes();
        for (FileAttribute<?> fa : attribs) {
            if (fa == null) continue;
            result.attributes.add(fa);
        }
        return result;
    }

    public FileAttributes() {
        this.attributes = new ArrayList();
    }

    private FileAttributes(List<FileAttribute<?>> attributes) {
        this.attributes = attributes;
    }

    public FileAttributes clone() {
        return new FileAttributes(new ArrayList(this.attributes));
    }

    public void add(String name, Object attributeValue) {
        this.add(FileAttributeType.UNKNOWN_ATTRIBUTE, name, attributeValue);
    }

    public void add(FileAttributeType attributeType, Object attributeValue) {
        this.add(attributeType, attributeType.getDisplayName(), attributeValue);
    }

    public void add(FileAttributeType attributeType, String displayName, Object attributeValue) {
        if (attributeValue != null) {
            this.attributes.add(FileAttribute.create(attributeType, displayName, attributeValue));
        }
    }

    public <T> T get(FileAttributeType attributeType, Class<T> valueClass, T defaultValue) {
        for (FileAttribute<?> attr : this.attributes) {
            if (attr.getAttributeType() != attributeType) continue;
            Object val = attr.getAttributeValue();
            if (!valueClass.isAssignableFrom(val.getClass())) break;
            return valueClass.cast(val);
        }
        return defaultValue;
    }

    public List<FileAttribute<?>> getAttributes() {
        return new ArrayList(this.attributes);
    }

    public boolean contains(FileAttributeType attributeType) {
        for (FileAttribute<?> attr : this.attributes) {
            if (attr.getAttributeType() != attributeType) continue;
            return true;
        }
        return false;
    }
}

