/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugin.importer;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.framework.main.datatable.ProjectDataTablePanel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectDataUtils;
import ghidra.framework.model.ProjectLocator;
import ghidra.util.Swing;
import ghidra.util.datastruct.ListenerSet;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public class ProjectIndexService
implements DomainFolderChangeListener,
AutoCloseable {
    public static final ProjectIndexService DUMMY = new ProjectIndexService(null);
    private static Map<ProjectLocator, ProjectIndexService> instances = new HashMap<ProjectLocator, ProjectIndexService>();
    private Project project;
    private List<IndexInfo> indexes = List.of(new IndexInfo(IndexType.MD5, this::getMD5), new IndexInfo(IndexType.FSRL, this::getFSRL));
    private Thread indexThread;
    private ListenerSet<ProjectIndexListener> indexListeners = new ListenerSet(ProjectIndexListener.class, false);

    public static synchronized ProjectIndexService getIndexFor(Project project) {
        if (project == null || project.isClosed()) {
            return DUMMY;
        }
        ProjectIndexService result = instances.get(project.getProjectLocator());
        if (result == null) {
            result = new ProjectIndexService(project);
            instances.put(project.getProjectLocator(), result);
        }
        return result;
    }

    public static synchronized void projectClosed(Project project) {
        ProjectLocator projectLocator;
        ProjectIndexService result;
        if (project != null && (result = instances.get(projectLocator = project.getProjectLocator())) != null) {
            instances.remove(projectLocator);
            result.close();
        }
    }

    public ProjectIndexService(Project project) {
        this.project = project;
        if (project != null) {
            ProjectData projectData = project.getProjectData();
            projectData.addDomainFolderChangeListener((DomainFolderChangeListener)this);
            this.indexProject(projectData);
        }
    }

    @Override
    public synchronized void close() {
        if (this.project != null) {
            this.project.getProjectData().removeDomainFolderChangeListener((DomainFolderChangeListener)this);
            for (IndexInfo index : this.indexes) {
                index.indexedFiles.clear();
            }
            this.project = null;
            this.indexListeners.clear();
            Thread localIndexThread = this.indexThread;
            if (localIndexThread != null && localIndexThread.isAlive()) {
                localIndexThread.interrupt();
            }
        }
    }

    public synchronized void addIndexListener(ProjectIndexListener listener) {
        if (this.project != null) {
            this.indexListeners.add((Object)listener);
        }
    }

    public synchronized void removeIndexListener(ProjectIndexListener listener) {
        this.indexListeners.remove((Object)listener);
    }

    public void domainFileAdded(DomainFile file) {
        this.indexFile(file);
        ((ProjectIndexListener)this.indexListeners.invoke()).indexUpdated();
    }

    public void domainFileRemoved(DomainFolder parent, String name, String fileID) {
        this.removeFile(fileID);
        ((ProjectIndexListener)this.indexListeners.invoke()).indexUpdated();
    }

    private void indexProject(ProjectData projectData) {
        int fileCount = projectData.getFileCount();
        if (fileCount < 0 || fileCount > ProjectDataTablePanel.MAX_FILE_COUNT) {
            return;
        }
        this.indexThread = new Thread(() -> {
            int count = 0;
            for (DomainFile df : ProjectDataUtils.descendantFiles((DomainFolder)projectData.getRootFolder())) {
                if (this.indexThread.isInterrupted()) break;
                this.indexFile(df);
                if (count++ % 10 != 0) continue;
                ((ProjectIndexListener)this.indexListeners.invoke()).indexUpdated();
                Swing.allowSwingToProcessEvents();
            }
            this.indexThread = null;
            ((ProjectIndexListener)this.indexListeners.invoke()).indexUpdated();
        }, "Project Indexing Thread");
        this.indexThread.setDaemon(true);
        this.indexThread.start();
    }

    private String getMD5(DomainFile file, Map<String, String> metadata) {
        return metadata.get(IndexType.MD5.metadataKey);
    }

    private FSRL getFSRL(DomainFile file, Map<String, String> metadata) {
        String fsrlStr = metadata.get(IndexType.FSRL.metadataKey);
        try {
            return fsrlStr != null ? FSRL.fromString(fsrlStr).withMD5(null) : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public synchronized List<DomainFile> lookupFiles(IndexType keyType, Object keyValue) {
        List<Object> fileIds;
        IndexInfo index = this.indexes.get(keyType.ordinal());
        Object fileInfo = index.indexedFiles.get(keyValue);
        if (fileInfo instanceof String) {
            String fileIdStr = (String)fileInfo;
            fileIds = List.of(fileIdStr);
        } else if (fileInfo instanceof List) {
            List fileInfoList = (List)fileInfo;
            fileIds = fileInfoList;
        } else {
            fileIds = List.of();
        }
        return fileIds.stream().map(fileId -> this.project.getProjectData().getFileByID(fileId)).filter(Objects::nonNull).toList();
    }

    public DomainFile findFirstByFSRL(FSRL fsrl) {
        List<DomainFile> files = this.lookupFiles(IndexType.FSRL, fsrl = fsrl.withMD5(null));
        return !files.isEmpty() ? files.get(0) : null;
    }

    private synchronized void indexFile(DomainFile file) {
        String newFileId = file.getFileID();
        if (newFileId == null) {
            return;
        }
        Map metadata = file.getMetadata();
        for (IndexInfo index : this.indexes) {
            String prevFileId;
            Object indexedValue = index.mappingFunc.apply(file, metadata);
            if (indexedValue == null) continue;
            Object fileInfo = index.indexedFiles.get(indexedValue);
            if (fileInfo == null) {
                index.indexedFiles.put(indexedValue, newFileId);
                continue;
            }
            if (fileInfo instanceof List) {
                List fileInfoList = (List)fileInfo;
                fileInfoList.add(newFileId);
                continue;
            }
            if (!(fileInfo instanceof String) || newFileId.equals(prevFileId = (String)fileInfo)) continue;
            ArrayList<String> fileInfoList = new ArrayList<String>();
            fileInfoList.add(prevFileId);
            fileInfoList.add(newFileId);
            index.indexedFiles.put(indexedValue, fileInfoList);
        }
    }

    private synchronized void removeFile(String fileId) {
        for (IndexInfo index : this.indexes) {
            Iterator<Object> it = index.indexedFiles.values().iterator();
            while (it.hasNext()) {
                String fileIdStr;
                Object fileInfo = it.next();
                if (fileInfo instanceof String && (fileIdStr = (String)fileInfo).equals(fileId)) {
                    it.remove();
                    continue;
                }
                if (!(fileInfo instanceof List)) continue;
                List fileInfoList = (List)fileInfo;
                fileInfoList.remove(fileId);
                if (!fileInfoList.isEmpty()) continue;
                it.remove();
            }
        }
    }

    record IndexInfo(IndexType indexType, BiFunction<DomainFile, Map<String, String>, Object> mappingFunc, Map<Object, Object> indexedFiles) {
        IndexInfo(IndexType indexType, BiFunction<DomainFile, Map<String, String>, Object> mappingFunc) {
            this(indexType, mappingFunc, new HashMap<Object, Object>());
        }
    }

    public static enum IndexType {
        MD5("Executable MD5"),
        FSRL("FSRL");

        private String metadataKey;

        private IndexType(String metadataKey) {
            this.metadataKey = metadataKey;
        }

        public String getMetadataKey() {
            return this.metadataKey;
        }
    }

    public static interface ProjectIndexListener {
        public void indexUpdated();
    }
}

