/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import generic.lsh.vector.LSHVectorFactory;
import ghidra.app.util.NamespaceUtils;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.features.bsim.gui.filters.FunctionTagBSimFilterType;
import ghidra.features.bsim.gui.search.results.BSimMatchResult;
import ghidra.features.bsim.gui.search.results.BSimResultStatus;
import ghidra.features.bsim.gui.search.results.BSimStatusRenderer;
import ghidra.features.bsim.gui.search.results.ShowNamespaceSettingsDefinition;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.AddressBasedLocation;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;

public class BSimMatchResultsModel
extends AddressBasedTableModel<BSimMatchResult> {
    private static final ShowNamespaceSettingsDefinition SHOW_NAMESPACE = ShowNamespaceSettingsDefinition.DEF;
    private static SettingsDefinition[] SETTINGS_DEFS = new SettingsDefinition[]{SHOW_NAMESPACE};
    private Collection<BSimMatchResult> results = new ArrayList<BSimMatchResult>();
    private Map<Address, Integer> functionMatchMap = new HashMap<Address, Integer>();

    public BSimMatchResultsModel(PluginTool tool, DatabaseInformation info, LSHVectorFactory lshVectorFactory) {
        super("Query Results", (ServiceProvider)tool, null, null);
        this.addCustomColumns(info, lshVectorFactory);
    }

    private void addCustomColumns(DatabaseInformation info, LSHVectorFactory lshVectorFactory) {
        if (info == null) {
            return;
        }
        if (info.execats != null) {
            for (String element : info.execats) {
                this.addTableColumn((DynamicTableColumn)new ExecCategoryColumn(element));
            }
        }
        if (info.functionTags != null) {
            int mask = 1;
            mask <<= FunctionTagBSimFilterType.RESERVED_BITS;
            for (String element : info.functionTags) {
                this.addTableColumn((DynamicTableColumn)new FunctionTagColumn(element, mask));
                mask <<= 1;
            }
        }
        if (info.dateColumnName != null) {
            this.addTableColumn((DynamicTableColumn)new ExecDateColumn(info.dateColumnName));
        } else {
            this.addTableColumn((DynamicTableColumn)new ExecDateColumn("Ingest Date"));
        }
        if (lshVectorFactory != null) {
            this.addTableColumn((DynamicTableColumn)new SelfSignificanceColumn(lshVectorFactory), -1, false);
        }
    }

    protected TableColumnDescriptor<BSimMatchResult> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new StatusColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new SimilarityColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new SignificanceColumn(), 1, false);
        descriptor.addVisibleColumn((DynamicTableColumn)new QueryFunctionColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new FuncNameMatchColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ExecNameMatchColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new ArchitectureMatchColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new ExecMd5Column());
        descriptor.addHiddenColumn((DynamicTableColumn)new CompilerMatchColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new MatchCountTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new FunctionSizeTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new FunctionTagColumn("Known Library", FunctionTagBSimFilterType.KNOWN_LIBRARY_MASK));
        descriptor.addHiddenColumn((DynamicTableColumn)new FunctionTagColumn("Has Unimplemented", FunctionTagBSimFilterType.HAS_UNIMPLEMENTED_MASK));
        descriptor.addHiddenColumn((DynamicTableColumn)new FunctionTagColumn("Has Bad Data", FunctionTagBSimFilterType.HAS_BADDATA_MASK));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()));
        descriptor.addHiddenColumn((DynamicTableColumn)new MatchingFunctionAddressTableColumn());
        return descriptor;
    }

    public Address getAddress(int row) {
        int index = this.getColumnIndex(AddressTableColumn.class);
        return ((AddressBasedLocation)this.getValueAt(row, index)).getAddress();
    }

    protected void doLoad(Accumulator<BSimMatchResult> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.results.isEmpty()) {
            return;
        }
        for (BSimMatchResult similarFunction : this.results) {
            accumulator.add((Object)similarFunction);
        }
    }

    void addResult(Collection<BSimMatchResult> result) {
        if (result == null) {
            return;
        }
        for (BSimMatchResult function : result) {
            this.addObject(function);
        }
    }

    void reload(Program newProgram, List<BSimMatchResult> rowset) {
        this.setProgram(newProgram);
        if (rowset == null) {
            this.clear();
            return;
        }
        this.results = rowset;
        this.parseFunctionMatchCounts(this.results);
        super.reload();
    }

    private void parseFunctionMatchCounts(Collection<BSimMatchResult> queryResults) {
        this.functionMatchMap.clear();
        for (BSimMatchResult result : queryResults) {
            Address key = result.getAddress();
            this.functionMatchMap.put(key, this.functionMatchMap.getOrDefault(key, 0) + 1);
        }
    }

    void clear() {
        this.clearData();
    }

    public static Address recoverAddress(FunctionDescription desc, Program prog) {
        Address address = prog.getAddressFactory().getDefaultAddressSpace().getAddress(desc.getAddress());
        Function func = prog.getFunctionManager().getFunctionAt(address);
        if (func != null && func.getName(true).equals(desc.getFunctionName())) {
            return address;
        }
        Function f = BSimMatchResultsModel.getUniqueFunction(desc, prog);
        if (f != null) {
            return f.getEntryPoint();
        }
        return address;
    }

    private static Function getUniqueFunction(FunctionDescription desc, Program prog) {
        Function f = null;
        for (Namespace namespace : NamespaceUtils.getNamespacesByName((Program)prog, null, (String)desc.getFunctionName())) {
            if (!(namespace instanceof Function)) continue;
            if (f != null) {
                return null;
            }
            f = (Function)namespace;
        }
        return f;
    }

    private static class ExecCategoryColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, String> {
        private String columnName;

        ExecCategoryColumn(String name) {
            super("ExecCategoryColumn: " + name);
            this.columnName = name;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getValue(BSimMatchResult rowObject, Settings settings, Program p, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getExeCategoryAlphabetic(this.columnName);
        }

        public int getColumnPreferredWidth() {
            return 200;
        }
    }

    private static class FunctionTagColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, Boolean> {
        private String columnName;
        private int mask;

        FunctionTagColumn(String name, int m) {
            super("Function Tag: " + name);
            this.columnName = name;
            this.mask = m;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Boolean getValue(BSimMatchResult rowObject, Settings settings, Program p, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.isFlagSet(this.mask);
        }

        public int getColumnPreferredWidth() {
            return 200;
        }
    }

    private static class ExecDateColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, Date> {
        private String columnName;

        ExecDateColumn(String name) {
            this.columnName = name;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Date getValue(BSimMatchResult rowObject, Settings settings, Program p, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getDate();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private static class SelfSignificanceColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, Double> {
        private DoubleRenderer doubleRenderer = new DoubleRenderer();
        private LSHVectorFactory vectorFactory;

        public SelfSignificanceColumn(LSHVectorFactory vectorFactory) {
            this.vectorFactory = vectorFactory;
        }

        public String getColumnName() {
            return "Matching Function Self Significance";
        }

        public Double getValue(BSimMatchResult rowObject, Settings settings, Program p, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return this.vectorFactory.getSelfSignificance(rowObject.getMatchFunctionDescription().getSignatureRecord().getLSHVector());
        }

        public GColumnRenderer<Double> getColumnRenderer() {
            return this.doubleRenderer;
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private static class StatusColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, BSimResultStatus> {
        private BSimStatusRenderer statusRenderer = new BSimStatusRenderer();

        private StatusColumn() {
        }

        public String getColumnName() {
            return "Status";
        }

        public BSimResultStatus getValue(BSimMatchResult rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            BSimResultStatus status = rowObject.getStatus();
            Function function = program.getFunctionManager().getFunctionAt(rowObject.getAddress());
            if (function == null) {
                return BSimResultStatus.NO_FUNCTION;
            }
            boolean nameMatches = this.hasMatchingFunctionName(function, rowObject);
            if (status == BSimResultStatus.NAME_APPLIED) {
                return nameMatches ? BSimResultStatus.NAME_APPLIED : BSimResultStatus.APPLIED_NO_LONGER_MATCHES;
            }
            if (status == BSimResultStatus.SIGNATURE_APPLIED) {
                return nameMatches ? BSimResultStatus.SIGNATURE_APPLIED : BSimResultStatus.APPLIED_NO_LONGER_MATCHES;
            }
            if (nameMatches) {
                return BSimResultStatus.MATCHES;
            }
            return status == BSimResultStatus.ERROR ? BSimResultStatus.ERROR : BSimResultStatus.NOT_APPLIED;
        }

        private boolean hasMatchingFunctionName(Function function, BSimMatchResult result) {
            String name = function.getName(true);
            String matchName = result.getSimilarFunctionName();
            return name.equals(matchName);
        }

        public int getColumnPreferredWidth() {
            return 60;
        }

        public GColumnRenderer<BSimResultStatus> getColumnRenderer() {
            return this.statusRenderer;
        }
    }

    private static class SimilarityColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, Double> {
        private DoubleRenderer doubleRenderer = new DoubleRenderer();

        private SimilarityColumn() {
        }

        public String getColumnName() {
            return "Similarity";
        }

        public Double getValue(BSimMatchResult rowObject, Settings settings, Program p, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSimilarity();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }

        public GColumnRenderer<Double> getColumnRenderer() {
            return this.doubleRenderer;
        }
    }

    private static class SignificanceColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, Double> {
        private DoubleRenderer doubleRenderer = new DoubleRenderer();

        private SignificanceColumn() {
        }

        public String getColumnName() {
            return "Confidence";
        }

        public Double getValue(BSimMatchResult rowObject, Settings settings, Program p, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSignificance();
        }

        public GColumnRenderer<Double> getColumnRenderer() {
            return this.doubleRenderer;
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private static class QueryFunctionColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, String> {
        private QueryFunctionColumn() {
        }

        public String getColumnName() {
            return "Function Name";
        }

        public String getValue(BSimMatchResult rowObject, Settings settings, Program p, ServiceProvider serviceProvider) throws IllegalArgumentException {
            Address address = rowObject.getAddress();
            Function function = p.getFunctionManager().getFunctionAt(address);
            boolean showNamespace = SHOW_NAMESPACE.getValue(settings);
            if (function != null) {
                return function.getName(showNamespace);
            }
            return "Function Missing!";
        }

        public int getColumnPreferredWidth() {
            return 200;
        }

        public SettingsDefinition[] getSettingsDefinitions() {
            return SETTINGS_DEFS;
        }
    }

    private static class FuncNameMatchColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, String> {
        private FuncNameMatchColumn() {
        }

        public String getColumnName() {
            return "Matching Function Name";
        }

        public String getValue(BSimMatchResult rowObject, Settings settings, Program p, ServiceProvider serviceProvider) throws IllegalArgumentException {
            int lastIndexOf;
            String name = rowObject.getSimilarFunctionName();
            boolean showNamespace = SHOW_NAMESPACE.getValue(settings);
            if (!showNamespace && (lastIndexOf = name.lastIndexOf("::")) > 0) {
                name = name.substring(lastIndexOf + 2);
            }
            return name;
        }

        public int getColumnPreferredWidth() {
            return 200;
        }

        public SettingsDefinition[] getSettingsDefinitions() {
            return SETTINGS_DEFS;
        }
    }

    private static class ExecNameMatchColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, String> {
        private ExecNameMatchColumn() {
        }

        public String getColumnName() {
            return "Exe Name";
        }

        public String getValue(BSimMatchResult rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getExecutableName();
        }

        public int getColumnPreferredWidth() {
            return 200;
        }
    }

    private static class ArchitectureMatchColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, String> {
        private ArchitectureMatchColumn() {
        }

        public String getColumnName() {
            return "Architecture";
        }

        public String getValue(BSimMatchResult rowObject, Settings settings, Program p, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getArchitecture();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private static class ExecMd5Column
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, String> {
        private ExecMd5Column() {
        }

        public String getColumnName() {
            return "Md5";
        }

        public String getValue(BSimMatchResult rowObject, Settings settings, Program p, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getMd5();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private static class CompilerMatchColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, String> {
        private CompilerMatchColumn() {
        }

        public String getColumnName() {
            return "Compiler";
        }

        public String getValue(BSimMatchResult rowObject, Settings settings, Program p, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getCompilerName();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private class MatchCountTableColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, Integer> {
        private MatchCountTableColumn() {
        }

        public String getColumnName() {
            return "Matches";
        }

        public Integer getValue(BSimMatchResult rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            return BSimMatchResultsModel.this.functionMatchMap.get(rowObject.getAddress());
        }

        public int getColumnPreferredWidth() {
            return 50;
        }
    }

    private static class FunctionSizeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, Long> {
        private FunctionSizeTableColumn() {
        }

        public String getColumnName() {
            return "Size";
        }

        public Long getValue(BSimMatchResult rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            Address address = rowObject.getAddress();
            Function function = p.getFunctionManager().getFunctionAt(address);
            return function.getBody().getNumAddresses();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private static class MatchingFunctionAddressTableColumn
    extends AbstractProgramBasedDynamicTableColumn<BSimMatchResult, Long> {
        private AddressOffsetHexRenderer renderer = new AddressOffsetHexRenderer();

        private MatchingFunctionAddressTableColumn() {
        }

        public String getColumnName() {
            return "Matching Function Address";
        }

        public Long getValue(BSimMatchResult rowObject, Settings settings, Program p, ServiceProvider serviceProvider) throws IllegalArgumentException {
            Long addr = rowObject.getMatchFunctionDescription().getAddress();
            return addr;
        }

        public int getColumnPreferredWidth() {
            return 100;
        }

        public GColumnRenderer<Long> getColumnRenderer() {
            return this.renderer;
        }
    }

    private static class DoubleRenderer
    extends AbstractGColumnRenderer<Double> {
        private DoubleRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(data);
            Double value = (Double)data.getValue();
            if (value != null) {
                label.setText(this.formatNumber(value, data.getColumnSettings()));
                label.setToolTipText(value.toString());
            } else {
                label.setText("");
                label.setToolTipText(null);
            }
            return label;
        }

        public String getFilterString(Double t, Settings settings) {
            return this.formatNumber(t, settings);
        }

        public GColumnRenderer.ColumnConstraintFilterMode getColumnConstraintFilterMode() {
            return GColumnRenderer.ColumnConstraintFilterMode.ALLOW_CONSTRAINTS_FILTER_ONLY;
        }
    }

    private static class AddressOffsetHexRenderer
    extends AbstractGColumnRenderer<Long> {
        private AddressOffsetHexRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(data);
            label.setHorizontalAlignment(4);
            Long value = (Long)data.getValue();
            if (value != null) {
                label.setText(this.getValueString(value));
            }
            return label;
        }

        protected Font getDefaultFont() {
            return this.fixedWidthFont;
        }

        public String getFilterString(Long t, Settings settings) {
            return this.getValueString(t);
        }

        private String getValueString(Long v) {
            if (v == null) {
                return "";
            }
            String format = (v & 0xFFFFFFFF00000000L) == 0L ? "%08X" : "%016X";
            return String.format(format, v);
        }
    }
}

