/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query;

import ghidra.features.bsim.query.BSimClientFactory;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.framework.client.ClientUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;

public class BSimServerInfo
implements Comparable<BSimServerInfo> {
    public static final int DEFAULT_POSTGRES_PORT = 5432;
    public static final int DEFAULT_ELASTIC_PORT = 9200;
    public static final String H2_FILE_EXTENSION = ".mv.db";
    private final DBType dbType;
    private final String userinfo;
    private final String host;
    private final int port;
    private final String dbName;
    private String shortDbName;

    public BSimServerInfo(DBType dbType, String userinfo, String host, int port, String dbName) {
        Objects.requireNonNull(dbType, "DBType must be specified");
        this.dbType = dbType;
        if ((dbType == DBType.postgres || dbType == DBType.elastic) && StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("host required");
        }
        if (StringUtils.isEmpty((CharSequence)(dbName = dbName.trim()))) {
            throw new IllegalArgumentException("Non-empty dbName required");
        }
        if (dbType == DBType.file) {
            host = null;
            port = -1;
            userinfo = null;
            dbName = BSimServerInfo.cleanupFilename(dbName);
        } else {
            if (dbName.contains("/") || dbName.contains("\\")) {
                throw new IllegalArgumentException("Invalid " + String.valueOf((Object)dbType) + " dbName: " + dbName);
            }
            userinfo = BSimServerInfo.cleanupUserInfo(userinfo);
            if (port <= 0) {
                port = -1;
            }
            if (dbType == DBType.postgres && port <= 0) {
                port = 5432;
            }
            if (dbType == DBType.elastic && port <= 0) {
                port = 9200;
            }
        }
        this.userinfo = userinfo;
        this.host = host;
        this.port = port;
        this.dbName = dbName;
    }

    public BSimServerInfo(DBType dbType, String host, int port, String dbName) {
        this(dbType, null, host, port, dbName);
    }

    public BSimServerInfo(String dbName) {
        this.dbType = DBType.file;
        this.userinfo = null;
        this.host = null;
        this.port = -1;
        dbName = dbName.trim();
        if (StringUtils.isEmpty((CharSequence)dbName)) {
            throw new IllegalArgumentException("Non-empty dbName required");
        }
        this.dbName = BSimServerInfo.cleanupFilename(dbName);
    }

    public BSimServerInfo(URL url) throws IllegalArgumentException {
        DBType t = null;
        Object path = url.getPath();
        String protocol = url.getProtocol();
        if (protocol.equals("postgresql")) {
            t = DBType.postgres;
            this.host = BSimServerInfo.checkURLField(url.getHost(), "host");
            this.userinfo = BSimServerInfo.getURLUserInfo(url);
            int p = url.getPort();
            this.port = p <= 0 ? 5432 : p;
        } else if (protocol.equals("https") || protocol.equals("elastic")) {
            t = DBType.elastic;
            this.host = BSimServerInfo.checkURLField(url.getHost(), "host");
            this.userinfo = BSimServerInfo.getURLUserInfo(url);
            int p = url.getPort();
            this.port = p <= 0 ? 9200 : p;
        } else if (protocol.startsWith("file")) {
            t = DBType.file;
            this.host = null;
            this.userinfo = null;
            this.port = -1;
            if (!"".equals(url.getHost())) {
                throw new IllegalArgumentException("Remote file URL not supported: " + String.valueOf(url));
            }
        } else {
            throw new IllegalArgumentException("Unsupported BSim URL protocol: " + protocol);
        }
        this.dbType = t;
        if (this.dbType == DBType.postgres || this.dbType == DBType.elastic) {
            if (!((String)path).startsWith("/")) {
                throw new IllegalArgumentException("Missing dbName in URL: " + String.valueOf(url));
            }
            path = ((String)path).substring(1).strip();
        }
        path = BSimServerInfo.urlDecode(BSimServerInfo.checkURLField((String)path, "path"));
        if (this.dbType == DBType.file) {
            if (((String)path).endsWith("/")) {
                throw new IllegalArgumentException("Missing DB filepath in URL: " + String.valueOf(url));
            }
            if (!((String)path).endsWith(H2_FILE_EXTENSION)) {
                path = (String)path + H2_FILE_EXTENSION;
            }
        } else if (((String)path).contains("/")) {
            throw new IllegalArgumentException("Invalid dbName in URL: " + (String)path);
        }
        this.dbName = path;
    }

    private static String getURLUserInfo(URL url) {
        String userinfo = url.getUserInfo();
        if (userinfo == null) {
            return null;
        }
        int pwSep = userinfo.indexOf(58);
        Object urlUserInfo = pwSep >= 0 ? BSimServerInfo.urlDecode(userinfo.substring(0, pwSep)) + ":" + BSimServerInfo.urlDecode(userinfo.substring(pwSep + 1)) : BSimServerInfo.urlDecode(userinfo);
        return BSimServerInfo.cleanupUserInfo((String)urlUserInfo);
    }

    private static String cleanupUserInfo(String userinfo) {
        if (StringUtils.isBlank((CharSequence)userinfo)) {
            return null;
        }
        int pwdSep = (userinfo = userinfo.trim()).indexOf(58);
        if (pwdSep == 0) {
            throw new IllegalArgumentException("Invalid userinfo specified");
        }
        if (pwdSep > 0 && userinfo.length() - pwdSep == 0) {
            throw new IllegalArgumentException("Invalid userinfo specified");
        }
        return userinfo;
    }

    private static String cleanupFilename(String name) {
        Object dbName = name.trim();
        if (!((String)(dbName = ((String)dbName).replace("\\", "/"))).startsWith("/") && !BSimServerInfo.isWindowsFilePath((String)dbName) || ((String)dbName).endsWith("/")) {
            throw new IllegalArgumentException("Invalid absolute file path: " + (String)dbName);
        }
        if (!((String)dbName).endsWith(H2_FILE_EXTENSION)) {
            dbName = (String)dbName + H2_FILE_EXTENSION;
        }
        return dbName;
    }

    private static String checkURLField(String val, String name) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            throw new IllegalArgumentException("Invalid " + name + " in URL");
        }
        return val.trim();
    }

    public boolean isWindowsFilePath() {
        return this.dbType == DBType.file && BSimServerInfo.isWindowsFilePath(this.dbName);
    }

    private static boolean isWindowsFilePath(String path) {
        if (path.length() < 4) {
            return false;
        }
        if (!Character.isLetter(path.charAt(0)) || path.charAt(1) != ':') {
            return false;
        }
        char c = path.charAt(2);
        if (c != '/') {
            return false;
        }
        c = path.charAt(3);
        return c != '/';
    }

    public String toURLString() {
        switch (this.dbType.ordinal()) {
            case 0: {
                return "postgresql://" + this.formatURLUserInfo() + this.host + this.getPortString() + "/" + BSimServerInfo.urlEncode(this.dbName);
            }
            case 1: {
                return "https://" + this.formatURLUserInfo() + this.host + this.getPortString() + "/" + BSimServerInfo.urlEncode(this.dbName);
            }
            case 2: {
                return "file:" + BSimServerInfo.urlEncode(this.dbName);
            }
        }
        throw new RuntimeException("Unsupported DBType: " + String.valueOf((Object)this.dbType));
    }

    private static String urlEncode(String text) {
        return URLEncoder.encode(text, StandardCharsets.UTF_8);
    }

    private static String urlDecode(String text) {
        return URLDecoder.decode(text, StandardCharsets.UTF_8);
    }

    private String formatURLUserInfo() {
        if (this.userinfo == null) {
            return "";
        }
        int pwSep = this.userinfo.indexOf(58);
        Object urlUserInfo = pwSep >= 0 ? BSimServerInfo.urlEncode(this.userinfo.substring(0, pwSep)) + ":" + BSimServerInfo.urlEncode(this.userinfo.substring(pwSep + 1)) : BSimServerInfo.urlEncode(this.userinfo);
        return (String)urlUserInfo + "@";
    }

    private String getPortString() {
        return this.port > 0 ? ":" + Integer.toString(this.port) : "";
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.toURLString());
    }

    public DBType getDBType() {
        return this.dbType;
    }

    public void setUserInfo(BasicDataSource bds) {
        bds.setUsername(this.getUserName());
        if (this.hasPassword()) {
            bds.setPassword(this.userinfo.substring(this.userinfo.indexOf(58) + 1));
        }
    }

    public boolean hasPassword() {
        return this.userinfo != null && this.userinfo.contains(":");
    }

    public boolean hasDefaultLogin() {
        return this.userinfo == null;
    }

    public String getUserName() {
        if (this.dbType == DBType.file) {
            return null;
        }
        if (this.userinfo == null) {
            return ClientUtil.getUserName();
        }
        String username = this.userinfo;
        int pwdSep = this.userinfo.indexOf(58);
        if (pwdSep > 0) {
            username = this.userinfo.substring(0, pwdSep);
        }
        return username;
    }

    public String getUserInfo() {
        return this.userinfo;
    }

    public String getServerName() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getShortDBName() {
        int ix;
        if (this.shortDbName != null) {
            return this.shortDbName;
        }
        this.shortDbName = this.dbName;
        if (this.dbType == DBType.file && (ix = this.dbName.lastIndexOf(47)) >= 0) {
            this.shortDbName = this.dbName.substring(ix + 1);
        }
        return this.shortDbName;
    }

    public int hashCode() {
        int hashcode = Objects.hash(this.dbName, this.dbType.ordinal(), this.host, this.port);
        if (this.userinfo != null) {
            hashcode = 31 * hashcode + this.userinfo.hashCode();
        }
        return hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof BSimServerInfo) {
            BSimServerInfo other = (BSimServerInfo)obj;
            return Objects.equals(this.dbName, other.dbName) && this.dbType == other.dbType && Objects.equals(this.userinfo, other.userinfo) && Objects.equals(this.host, other.host) && this.port == other.port;
        }
        return false;
    }

    public String toString() {
        switch (this.dbType.ordinal()) {
            case 2: {
                return this.getShortDBName() + "  (" + this.dbName + ");";
            }
        }
        return this.dbName + "  (" + String.valueOf((Object)this.dbType) + ": " + this.host + ")";
    }

    public FunctionDatabase getFunctionDatabase(boolean async) {
        return BSimClientFactory.buildClient(this, async);
    }

    @Override
    public int compareTo(BSimServerInfo o) {
        return this.toString().compareTo(o.toString());
    }

    public static enum DBType {
        postgres,
        elastic,
        file;

    }
}

