/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.PairNote;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class ResponsePair
extends QueryResponseRecord {
    public double averageSim;
    public double simStdDev;
    public double averageSig;
    public double sigStdDev;
    public double scale;
    public int pairCount;
    public int missedExe;
    public int missedFunc;
    public int missedVector;
    public List<PairNote> notes = new ArrayList<PairNote>();

    public ResponsePair() {
        super("responsepair");
    }

    public void fillOutStatistics(Accumulator accumulator) {
        this.pairCount = accumulator.pairCount;
        this.averageSim = accumulator.sumSim / (double)this.pairCount;
        this.averageSig = accumulator.sumSig / (double)this.pairCount;
        this.simStdDev = Math.sqrt(accumulator.sumSimSquare / (double)this.pairCount - this.averageSim * this.averageSim);
        this.sigStdDev = Math.sqrt(accumulator.sumSigSquare / (double)this.pairCount - this.averageSig * this.averageSig);
        this.missedExe = accumulator.missedExe;
        this.missedFunc = accumulator.missedFunc;
        this.missedVector = accumulator.missedVector;
    }

    public void saveXmlTail(Writer fwrite) throws IOException {
        fwrite.append(" <avesim>").append(Double.toString(this.averageSim)).append("</avesim>\n");
        fwrite.append(" <simstddev>").append(Double.toString(this.simStdDev)).append("</simstddev>\n");
        fwrite.append(" <avesig>").append(Double.toString(this.averageSig)).append("</avesig>\n");
        fwrite.append(" <sigstddev>").append(Double.toString(this.sigStdDev)).append("</sigstddev>\n");
        fwrite.append(" <scale>").append(Double.toString(this.scale)).append("</scale>\n");
        fwrite.append(" <paircount>").append(Integer.toString(this.pairCount)).append("</paircount>\n");
        fwrite.append(" <missedexe>").append(Integer.toString(this.missedExe)).append("</missedexe>\n");
        fwrite.append(" <missedfunc>").append(Integer.toString(this.missedFunc)).append("</missedfunc>\n");
        fwrite.append(" <missedvector>").append(Integer.toString(this.missedVector)).append("</missedvector>\n");
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        for (PairNote note : this.notes) {
            note.saveXml(fwrite);
        }
        this.saveXmlTail(fwrite);
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        XmlElement note;
        XmlElement startEl = parser.start(new String[]{this.name});
        while ((note = parser.peek()).isStart() && note.getName().equals("note")) {
            PairNote pairNote = new PairNote();
            pairNote.restoreXml(parser);
            this.notes.add(pairNote);
        }
        parser.start(new String[]{"avesim"});
        this.averageSim = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"simstddev"});
        this.simStdDev = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"avesig"});
        this.averageSig = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"sigstddev"});
        this.sigStdDev = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"scale"});
        this.scale = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"paircount"});
        this.pairCount = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"missedexe"});
        this.missedExe = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"missedfunc"});
        this.missedFunc = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"missedvector"});
        this.missedVector = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.end(startEl);
    }

    public static class Accumulator {
        public double sumSim = 0.0;
        public double sumSimSquare = 0.0;
        public double sumSig = 0.0;
        public double sumSigSquare = 0.0;
        public int missedExe = 0;
        public int missedFunc = 0;
        public int missedVector = 0;
        public int pairCount = 0;

        public void merge(ResponsePair responsePair) {
            this.pairCount += responsePair.pairCount;
            this.missedExe += responsePair.missedExe;
            this.missedFunc += responsePair.missedFunc;
            this.missedVector += responsePair.missedVector;
            this.sumSim += responsePair.averageSim * (double)responsePair.pairCount;
            this.sumSig += responsePair.averageSig * (double)responsePair.pairCount;
            double aveSimSquare = responsePair.simStdDev * responsePair.simStdDev + responsePair.averageSim * responsePair.averageSim;
            this.sumSimSquare += aveSimSquare * (double)responsePair.pairCount;
            double aveSigSquare = responsePair.sigStdDev * responsePair.sigStdDev + responsePair.averageSig * responsePair.averageSig;
            this.sumSigSquare += aveSigSquare * (double)responsePair.pairCount;
        }
    }
}

