/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.program;

import ghidra.graph.DataFlowGraphType;
import ghidra.graph.ProgramGraphType;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class DataReferenceGraph
extends AttributedGraph {
    public static final String REF_SOURCE_ATTRIBUTE = "Source";
    public static final String REF_TYPE_ATTRIBUTE = "Type";
    public static final String REF_SYMBOL_ATTRIBUTE = "Symbol";
    public static final String DATA_ATTRIBUTE = "DataType";
    public static final String ADDRESS_ATTRIBUTE = "Address";
    public static final String LABEL_ATTRIBUTE = "Label";
    private Program program;
    private int depthPerStep;

    public DataReferenceGraph(Program program, int depth) {
        super("Data Reference", (GraphType)new DataFlowGraphType());
        this.program = program;
        this.depthPerStep = depth;
    }

    public String makeName(Address address) {
        CodeUnit unit = this.program.getListing().getCodeUnitContaining(address);
        if (unit == null) {
            return address.toString();
        }
        Address unitAddress = unit.getAddress();
        String name = this.program.getSymbolTable().getPrimarySymbol(unitAddress) != null ? this.program.getSymbolTable().getPrimarySymbol(unitAddress).getName(true) : unitAddress.toString();
        return name;
    }

    public AttributedVertex graphFrom(Address baseAddress, Directions direction, TaskMonitor monitor) throws CancelledException {
        if (baseAddress == null) {
            return null;
        }
        AttributedVertex baseVertex = new AttributedVertex(this.makeName(baseAddress));
        baseVertex.setAttribute(ADDRESS_ATTRIBUTE, baseAddress.toString());
        this.setupVertex(baseVertex);
        this.addVertex(baseVertex);
        this.recurseGraph(baseAddress, this.depthPerStep, direction, monitor);
        return baseVertex;
    }

    private void setupEdge(AttributedEdge edge, Reference ref) {
        edge.setAttribute(REF_SOURCE_ATTRIBUTE, ref.getSource().getDisplayString());
        edge.setEdgeType(ProgramGraphType.getEdgeType((RefType)ref.getReferenceType()));
        if (ref.getSymbolID() != -1L) {
            edge.setAttribute(REF_SYMBOL_ATTRIBUTE, this.program.getSymbolTable().getSymbol(ref.getSymbolID()).getName());
        }
    }

    private void setupVertex(AttributedVertex vertex) {
        Address address = this.program.getAddressFactory().getAddress(vertex.getAttribute(ADDRESS_ATTRIBUTE));
        if (address == null) {
            return;
        }
        CodeUnit unit = this.program.getListing().getCodeUnitContaining(address);
        if (unit instanceof Data) {
            vertex.setAttribute(DATA_ATTRIBUTE, ((Data)unit).getBaseDataType().getName());
            vertex.setVertexType(ProgramGraphType.DATA);
        } else if (unit instanceof Instruction) {
            vertex.setVertexType(ProgramGraphType.INSTRUCTION);
        } else {
            vertex.setVertexType(ProgramGraphType.STACK);
        }
    }

    private void recurseGraph(Address startAddress, int maxDepth, Directions direction, TaskMonitor monitor) throws CancelledException {
        AttributedVertex startVertex = this.getVertex(this.makeName(startAddress));
        if (direction != Directions.FROM_ONLY) {
            for (Reference ref : this.program.getListing().getCodeUnitContaining(startAddress).getReferenceIteratorTo()) {
                if (ref.getReferenceType().isFlow()) continue;
                Address nextAddress = this.processReference(Directions.TO_ONLY, startVertex, ref);
                monitor.checkCancelled();
                if (nextAddress == null) continue;
                if (maxDepth > 1) {
                    this.recurseGraph(nextAddress, maxDepth - 1, direction, monitor);
                    continue;
                }
                if (maxDepth != 0) continue;
                this.recurseGraph(nextAddress, 0, direction, monitor);
            }
        }
        if (direction != Directions.TO_ONLY) {
            for (Reference ref : this.program.getListing().getCodeUnitContaining(startAddress).getReferencesFrom()) {
                if (ref.getReferenceType().isFlow()) continue;
                Address nextAddress = this.processReference(Directions.FROM_ONLY, startVertex, ref);
                monitor.checkCancelled();
                if (nextAddress == null) continue;
                if (maxDepth > 1) {
                    this.recurseGraph(nextAddress, maxDepth - 1, direction, monitor);
                    continue;
                }
                if (maxDepth != 0) continue;
                this.recurseGraph(nextAddress, 0, direction, monitor);
            }
        }
    }

    private Address processReference(Directions direction, AttributedVertex startVertex, Reference ref) {
        Address targetAddress = direction == Directions.TO_ONLY ? ref.getFromAddress() : ref.getToAddress();
        AttributedVertex newVertex = new AttributedVertex(this.makeName(targetAddress));
        newVertex.setAttribute(ADDRESS_ATTRIBUTE, targetAddress.toString());
        this.setupVertex(newVertex);
        AttributedEdge edge = direction == Directions.TO_ONLY ? this.addEdge(newVertex, startVertex) : this.addEdge(startVertex, newVertex);
        if (edge.hasAttribute("Weight")) {
            return null;
        }
        this.setupEdge(edge, ref);
        return targetAddress;
    }

    public static enum Directions {
        TO_ONLY,
        FROM_ONLY,
        BOTH_WAYS;

    }
}

