/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.cmd;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;

public class CompoundBackgroundCommand<T extends DomainObject>
extends BackgroundCommand<T> {
    private ArrayList<Command<T>> cmdList = new ArrayList();

    public CompoundBackgroundCommand(String name, boolean modal, boolean canCancel) {
        super(name, false, canCancel, modal);
    }

    @Override
    public boolean applyTo(T obj, TaskMonitor monitor) {
        for (Command<T> cmd : this.cmdList) {
            boolean success;
            if (monitor.isCancelled()) {
                this.setStatusMsg("Cancelled");
                return false;
            }
            if (cmd instanceof BackgroundCommand) {
                BackgroundCommand bcmd = (BackgroundCommand)cmd;
                success = bcmd.applyTo(obj, monitor);
            } else {
                success = cmd.applyTo(obj);
            }
            if (success) continue;
            this.setStatusMsg(cmd.getStatusMsg());
            return false;
        }
        return true;
    }

    public void add(Command<T> cmd) {
        this.cmdList.add(cmd);
    }

    public int size() {
        return this.cmdList.size();
    }

    public boolean isEmpty() {
        return this.cmdList.isEmpty();
    }
}

