/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import generic.timer.GhidraTimer;
import generic.timer.GhidraTimerFactory;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;

class DomainObjectChangeSupport {
    private WeakSet<DomainObjectListener> listeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private List<EventNotification> notificationQueue = new ArrayList<EventNotification>();
    private List<DomainObjectChangeRecord> recordsQueue = new ArrayList<DomainObjectChangeRecord>();
    private GhidraTimer timer;
    private DomainObject src;
    private Lock domainObjectLock;
    private Lock writeLock = new Lock("DOCS Change Records Queue Lock");
    private volatile boolean isDisposed;

    DomainObjectChangeSupport(DomainObject src, int timeInterval, Lock lock) {
        this.src = Objects.requireNonNull(src);
        this.domainObjectLock = Objects.requireNonNull(lock);
        this.timer = GhidraTimerFactory.getGhidraTimer((int)timeInterval, (int)timeInterval, this::sendEventNow);
        this.timer.setInitialDelay(25);
        this.timer.setDelay(timeInterval);
        this.timer.setRepeats(true);
    }

    private DomainObjectChangedEvent createEventFromQueuedRecords() {
        if (this.recordsQueue.isEmpty()) {
            this.timer.stop();
            return null;
        }
        DomainObjectChangedEvent e = new DomainObjectChangedEvent(this.src, this.recordsQueue);
        this.recordsQueue = new ArrayList<DomainObjectChangeRecord>();
        return e;
    }

    void addListener(DomainObjectListener listener) {
        if (this.isDisposed) {
            return;
        }
        this.withLock(() -> {
            Collection previousListeners = this.listeners.values();
            this.listeners.add((Object)listener);
            DomainObjectChangedEvent pendingEvent = this.createEventFromQueuedRecords();
            if (pendingEvent != null) {
                this.notificationQueue.add(new EventNotification(pendingEvent, previousListeners));
                this.timer.start();
            }
        });
    }

    void removeListener(DomainObjectListener listener) {
        if (this.isDisposed) {
            return;
        }
        this.withLock(() -> this.listeners.remove((Object)listener));
    }

    void flush() {
        Thread lockOwner = this.domainObjectLock.getOwner();
        if (lockOwner == Thread.currentThread()) {
            throw new IllegalStateException("Cannot call flush() with locks!");
        }
        this.sendEventNow();
    }

    private void sendEventNow() {
        List notifications = this.withLock(() -> {
            DomainObjectChangedEvent e = this.createEventFromQueuedRecords();
            if (e != null) {
                this.notificationQueue.add(new EventNotification(e, this.listeners.values()));
            }
            if (this.notificationQueue.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<EventNotification> existingNotifications = new ArrayList<EventNotification>(this.notificationQueue);
            this.notificationQueue.clear();
            return existingNotifications;
        });
        if (notifications.isEmpty()) {
            return;
        }
        Swing.runNow(() -> this.doSendEventsNow(notifications));
    }

    private void doSendEventsNow(List<EventNotification> notifications) {
        for (EventNotification notification : notifications) {
            notification.doNotify();
        }
    }

    void fireEvent(DomainObjectChangeRecord docr) {
        if (this.isDisposed) {
            return;
        }
        this.withLock(() -> {
            this.recordsQueue.add(docr);
            this.timer.start();
        });
    }

    void fatalErrorOccurred(Throwable t) {
        if (this.isDisposed) {
            return;
        }
        List listenersCopy = this.withLock(() -> new ArrayList(this.listeners.values()));
        this.dispose();
        Runnable errorTask = () -> {
            List<DomainObjectChangeRecord> records = Arrays.asList(new DomainObjectChangeRecord(DomainObjectEvent.ERROR, null, t));
            DomainObjectChangedEvent ev = new DomainObjectChangedEvent(this.src, records);
            for (DomainObjectListener l : listenersCopy) {
                try {
                    l.domainObjectChanged(ev);
                }
                catch (Throwable throwable) {}
            }
        };
        Swing.runLater((Runnable)errorTask);
    }

    void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.withLock(() -> {
            this.isDisposed = true;
            this.timer.stop();
            this.recordsQueue.clear();
            this.notificationQueue.clear();
            this.listeners.clear();
        });
    }

    private void withLock(Runnable r) {
        try {
            this.writeLock.acquire();
            r.run();
        }
        finally {
            this.writeLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withLock(Callable<T> c) {
        try {
            T t;
            this.writeLock.acquire();
            try {
                T result;
                t = result = c.call();
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)"Exception while updating change records", (Throwable)e);
                T t2 = null;
                this.writeLock.release();
                return t2;
            }
            return t;
        }
        finally {
            this.writeLock.release();
        }
    }

    private class EventNotification {
        private DomainObjectChangedEvent event;
        private Collection<DomainObjectListener> receivers;

        EventNotification(DomainObjectChangedEvent event, Collection<DomainObjectListener> recievers) {
            this.event = event;
            this.receivers = recievers;
        }

        void doNotify() {
            if (DomainObjectChangeSupport.this.isDisposed) {
                return;
            }
            if (this.event == null) {
                return;
            }
            for (DomainObjectListener dol : this.receivers) {
                try {
                    dol.domainObjectChanged(this.event);
                }
                catch (Exception exc) {
                    Msg.showError((Object)this, null, (String)"Error", (Object)"Error in Domain Object listener", (Throwable)exc);
                }
            }
        }
    }
}

