/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.util.InvalidNameException;
import java.io.IOException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;

public class ProjectDataUtils {
    public static Iterable<DomainFile> descendantFiles(DomainFolder folder) {
        return () -> new DomainFileIterator(folder);
    }

    public static Iterable<DomainFolder> descendantFolders(DomainFolder folder) {
        return () -> new DomainFolderIterator(folder);
    }

    public static DomainFolder createDomainFolderPath(DomainFolder currentFolder, String path) throws InvalidNameException, IOException {
        String[] pathElements;
        for (String pathElement : pathElements = path.split("/")) {
            if ((pathElement = pathElement.trim()).isEmpty()) continue;
            DomainFolder nextFolder = currentFolder.getFolder(pathElement);
            if (nextFolder == null) {
                nextFolder = currentFolder.createFolder(pathElement);
            }
            currentFolder = nextFolder;
        }
        return currentFolder;
    }

    public static DomainFolder lookupDomainPath(DomainFolder currentFolder, String path) {
        String[] pathElements;
        for (String pathElement : pathElements = path.split("/")) {
            if (!(pathElement = pathElement.trim()).isEmpty() && (currentFolder = currentFolder.getFolder(pathElement)) == null) break;
        }
        return currentFolder;
    }

    public static String getUniqueName(DomainFolder folder, String baseName) {
        int MAX_TRY_COUNT = 1000;
        for (int tryNum = 0; tryNum < MAX_TRY_COUNT; ++tryNum) {
            String tryName = baseName + (tryNum > 0 ? Integer.toString(tryNum) : "");
            if (folder.getFile(tryName) != null || folder.getFolder(tryName) != null) {
                continue;
            }
            return tryName;
        }
        return null;
    }

    public static class DomainFolderIterator
    implements Iterator<DomainFolder> {
        private Deque<DomainFolder> folderQueue = new LinkedList<DomainFolder>();
        private DomainFolder nextFolder;

        public DomainFolderIterator(Project project) {
            this(project.getProjectData().getRootFolder());
        }

        public DomainFolderIterator(DomainFolder startFolder) {
            this.folderQueue.add(startFolder);
        }

        private void queueNextFiles() {
            if (this.nextFolder == null && !this.folderQueue.isEmpty()) {
                this.nextFolder = this.folderQueue.poll();
                DomainFolder[] folders = this.nextFolder.getFolders();
                for (int i = folders.length - 1; i >= 0; --i) {
                    DomainFolder subfolder = folders[i];
                    this.folderQueue.addFirst(subfolder);
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.queueNextFiles();
            return this.nextFolder != null;
        }

        @Override
        public DomainFolder next() {
            DomainFolder tmp = this.nextFolder;
            this.nextFolder = null;
            return tmp;
        }
    }

    public static class DomainFileIterator
    implements Iterator<DomainFile> {
        private Deque<DomainFile> fileQueue = new LinkedList<DomainFile>();
        private Deque<DomainFolder> folderQueue = new LinkedList<DomainFolder>();

        public DomainFileIterator(Project project) {
            this(project.getProjectData().getRootFolder());
        }

        public DomainFileIterator(DomainFolder startFolder) {
            this.folderQueue.add(startFolder);
        }

        private void queueNextFiles() {
            DomainFolder folder;
            while (this.fileQueue.isEmpty() && (folder = this.folderQueue.poll()) != null) {
                DomainFolder[] folders = folder.getFolders();
                for (int i = folders.length - 1; i >= 0; --i) {
                    DomainFolder subfolder = folders[i];
                    this.folderQueue.addFirst(subfolder);
                }
                for (DomainFile subfile : folder.getFiles()) {
                    this.fileQueue.addLast(subfile);
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.queueNextFiles();
            return !this.fileQueue.isEmpty();
        }

        @Override
        public DomainFile next() {
            return this.fileQueue.poll();
        }
    }
}

