/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.tool;

import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.framework.ToolUtils;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.model.DefaultLaunchMode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ToolAssociationInfo;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolChestChangeListener;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.project.tool.GhidraToolTemplate;
import ghidra.framework.project.tool.ToolManagerImpl;
import ghidra.framework.project.tool.WorkspaceImpl;
import ghidra.framework.protocol.ghidra.ContentTypeQueryTask;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.util.Msg;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.xml.GenericXMLOutputter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jdom.Document;
import util.CollectionUtils;

class ToolServicesImpl
implements ToolServices {
    private static String TOOL_ASSOCIATION_PREFERENCE = "ToolAssociation";
    private static String SEPARATOR = ":";
    private ToolChest toolChest;
    private ToolManagerImpl toolManager;
    private ToolChestChangeListener toolChestChangeListener;

    ToolServicesImpl(ToolChest toolChest, ToolManagerImpl toolManager) {
        this.toolChest = toolChest;
        this.toolManager = toolManager;
    }

    void dispose() {
        this.toolChest.removeToolChestChangeListener(this.toolChestChangeListener);
    }

    @Override
    public void closeTool(PluginTool tool) {
        this.toolManager.closeTool(tool);
    }

    @Override
    public File exportTool(ToolTemplate tool) throws FileNotFoundException, IOException {
        File location = this.chooseToolFile(tool);
        if (location == null) {
            return location;
        }
        Object filename = location.getName();
        if (!((String)filename).endsWith(".tool")) {
            filename = (String)filename + ".tool";
        }
        try (FileOutputStream f = new FileOutputStream(location.getParent() + File.separator + (String)filename);){
            BufferedOutputStream bf = new BufferedOutputStream(f);
            Document doc = new Document(tool.saveToXml());
            GenericXMLOutputter xmlout = new GenericXMLOutputter();
            xmlout.output(doc, (OutputStream)bf);
        }
        return location;
    }

    private File chooseToolFile(ToolTemplate tool) {
        GhidraFileChooser fileChooser = this.getFileChooser();
        File exportFile = null;
        while (exportFile == null) {
            int result;
            exportFile = fileChooser.getSelectedFile();
            if (exportFile == null) {
                return null;
            }
            Preferences.setProperty((String)"LastToolExportDirectory", (String)exportFile.getParent());
            if (!exportFile.getName().endsWith(".tool")) {
                exportFile = new File(exportFile.getAbsolutePath() + ".tool");
            }
            if (!exportFile.exists() || (result = OptionDialog.showOptionDialog(null, (String)"Overwrite?", (String)("Overwrite existing file: '" + exportFile.getName() + "'?"), (String)"Overwrite", (int)3)) == 1) continue;
            exportFile = null;
        }
        fileChooser.dispose();
        return exportFile;
    }

    private GhidraFileChooser getFileChooser() {
        File dir;
        GhidraFileChooser newFileChooser = new GhidraFileChooser(null);
        newFileChooser.setFileFilter(new GhidraFileFilter(this){

            public boolean accept(File file, GhidraFileChooserModel model) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                return file.getAbsolutePath().toLowerCase().endsWith("tool");
            }

            public String getDescription() {
                return "Tools";
            }
        });
        String exportDir = Preferences.getProperty((String)"LastToolExportDirectory");
        if (exportDir != null && (dir = new File(exportDir)).isDirectory()) {
            newFileChooser.setCurrentDirectory(dir);
        }
        newFileChooser.setTitle("Export Tool");
        newFileChooser.setApproveButtonText("Export");
        return newFileChooser;
    }

    @Override
    public void saveTool(PluginTool tool) {
        boolean toolChanged = tool.hasConfigChanged();
        ToolTemplate template = tool.saveToolToToolTemplate();
        this.toolManager.toolSaved(tool, toolChanged);
        this.toolChest.replaceToolTemplate(template);
        this.toolManager.setWorkspaceChanged((WorkspaceImpl)this.toolManager.getActiveWorkspace());
    }

    @Override
    public ToolChest getToolChest() {
        return this.toolChest;
    }

    private static DefaultLaunchMode getDefaultLaunchMode() {
        DefaultLaunchMode defaultLaunchMode = DefaultLaunchMode.DEFAULT;
        FrontEndTool frontEndTool = AppInfo.getFrontEndTool();
        if (frontEndTool != null) {
            defaultLaunchMode = frontEndTool.getDefaultLaunchMode();
        }
        return defaultLaunchMode;
    }

    private PluginTool defaultLaunch(ToolTemplate template, Function<PluginTool, Boolean> openFunction) {
        DefaultLaunchMode defaultLaunchMode = ToolServicesImpl.getDefaultLaunchMode();
        if (defaultLaunchMode == DefaultLaunchMode.REUSE_TOOL) {
            if (template != null) {
                PluginTool[] defaultToolName = template.getName();
                PluginTool[] pluginToolArray = this.getRunningTools();
                int n = pluginToolArray.length;
                for (int i = 0; i < n; ++i) {
                    PluginTool tool = pluginToolArray[i];
                    if (!tool.getName().equals(defaultToolName) || !openFunction.apply(tool).booleanValue()) continue;
                    return tool;
                }
            }
            for (PluginTool tool : this.getRunningTools()) {
                if (!openFunction.apply(tool).booleanValue()) continue;
                return tool;
            }
        }
        if (template == null) {
            return null;
        }
        Workspace workspace = this.toolManager.getActiveWorkspace();
        PluginTool tool = workspace.runTool(template);
        if (tool == null) {
            return null;
        }
        tool.setVisible(true);
        openFunction.apply(tool);
        return tool;
    }

    @Override
    public PluginTool launchDefaultTool(Collection<DomainFile> domainFiles) {
        if (CollectionUtils.isBlank(domainFiles)) {
            throw new IllegalArgumentException("Domain files cannot be empty");
        }
        ToolTemplate template = this.getDefaultToolTemplate((DomainFile)CollectionUtils.any(domainFiles));
        return this.defaultLaunch(template, t -> t.acceptDomainFiles((DomainFile[])domainFiles.toArray(DomainFile[]::new)));
    }

    @Override
    public PluginTool launchTool(String toolName, Collection<DomainFile> domainFiles) {
        GhidraToolTemplate template = this.findToolChestToolTemplate(toolName);
        if (template == null) {
            return null;
        }
        return this.defaultLaunch(template, t -> {
            if (CollectionUtils.isBlank((Collection)domainFiles)) {
                return true;
            }
            return t.acceptDomainFiles((DomainFile[])domainFiles.toArray(DomainFile[]::new));
        });
    }

    @Override
    public PluginTool launchDefaultToolWithURL(URL ghidraUrl) throws IllegalArgumentException {
        String contentType = this.getContentType(ghidraUrl);
        if (contentType == null) {
            return null;
        }
        ToolTemplate template = this.getDefaultToolTemplate(contentType);
        return this.defaultLaunch(template, t -> t.accept(ghidraUrl));
    }

    @Override
    public PluginTool launchToolWithURL(String toolName, URL ghidraUrl) throws IllegalArgumentException {
        if (!GhidraURL.isLocalProjectURL(ghidraUrl) && !GhidraURL.isServerRepositoryURL(ghidraUrl)) {
            throw new IllegalArgumentException("unsupported URL");
        }
        GhidraToolTemplate template = this.findToolChestToolTemplate(toolName);
        if (template == null) {
            return null;
        }
        Workspace workspace = this.toolManager.getActiveWorkspace();
        PluginTool tool = workspace.runTool(template);
        if (tool != null) {
            tool.accept(ghidraUrl);
        }
        return tool;
    }

    private String getContentType(URL url) throws IllegalArgumentException {
        ContentTypeQueryTask task = new ContentTypeQueryTask(url);
        TaskLauncher.launch((Task)task);
        return task.getContentType();
    }

    @Override
    public void setContentTypeToolAssociations(Set<ToolAssociationInfo> infos) {
        for (ToolAssociationInfo info : infos) {
            ContentHandler handler = info.getContentHandler();
            String contentType = handler.getContentType();
            String preferenceKey = this.getToolAssociationPreferenceKey(contentType);
            if (!info.isDefault()) {
                ToolTemplate template = info.getCurrentTemplate();
                String toolName = template.getName();
                Preferences.setProperty((String)preferenceKey, (String)toolName);
            } else {
                Preferences.setProperty((String)preferenceKey, null);
            }
            this.ensureToolIsInToolChest(info.getCurrentTemplate());
        }
        Preferences.store();
    }

    private void ensureToolIsInToolChest(ToolTemplate template) {
        if (template == null) {
            return;
        }
        ToolTemplate existingTemplate = this.toolChest.getToolTemplate(template.getName());
        if (existingTemplate != null) {
            return;
        }
        this.toolChest.addToolTemplate(template);
    }

    @Override
    public Set<ToolAssociationInfo> getContentTypeToolAssociations() {
        HashSet<ToolAssociationInfo> set = new HashSet<ToolAssociationInfo>();
        Set<ContentHandler<?>> handlers = DomainObjectAdapter.getContentHandlers();
        for (ContentHandler<?> contentHandler : handlers) {
            if (contentHandler instanceof LinkHandler) continue;
            set.add(this.createToolAssociationInfo(contentHandler));
        }
        return set;
    }

    private ToolAssociationInfo createToolAssociationInfo(ContentHandler<?> contentHandler) {
        String contentType = contentHandler.getContentType();
        String defaultToolName = contentHandler.getDefaultToolName();
        String userPreferredToolName = Preferences.getProperty((String)this.getToolAssociationPreferenceKey(contentType), null, (boolean)true);
        if (userPreferredToolName != null) {
            GhidraToolTemplate userDefinedTemplate = this.findToolChestToolTemplate(userPreferredToolName);
            return new ToolAssociationInfo(contentHandler, userPreferredToolName, userDefinedTemplate, this.findDefaultToolTemplate(defaultToolName));
        }
        GhidraToolTemplate defaultToolChestTemplate = this.findToolChestToolTemplate(defaultToolName);
        return new ToolAssociationInfo(contentHandler, defaultToolName, defaultToolChestTemplate, this.findDefaultToolTemplate(defaultToolName));
    }

    @Override
    public ToolTemplate getDefaultToolTemplate(DomainFile domainFile) {
        return this.getDefaultToolTemplate(domainFile.getContentType());
    }

    @Override
    public ToolTemplate getDefaultToolTemplate(String contentType) {
        try {
            ContentHandler<?> contentHandler = DomainObjectAdapter.getContentHandler(contentType);
            if (contentHandler instanceof LinkHandler) {
                Class<?> domainObjectClass = contentHandler.getDomainObjectClass();
                contentHandler = DomainObjectAdapter.getContentHandler(domainObjectClass);
                contentType = contentHandler.getContentType();
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)e.getMessage());
            return null;
        }
        String toolName = Preferences.getProperty((String)this.getToolAssociationPreferenceKey(contentType), null, (boolean)true);
        if (toolName == null) {
            toolName = this.getDefaultToolAssociation(contentType);
        }
        return this.findToolChestToolTemplate(toolName);
    }

    @Override
    public Set<ToolTemplate> getCompatibleTools(Class<? extends DomainObject> domainClass) {
        Class<?>[] types;
        ToolTemplate[] toolTemplates;
        HashMap<String, ToolTemplate> nameToTemplateMap = new HashMap<String, ToolTemplate>();
        for (ToolTemplate toolTemplate : toolTemplates = this.toolChest.getToolTemplates()) {
            for (Class<? extends DomainObject> clazz : types = toolTemplate.getSupportedDataTypes()) {
                if (!clazz.isAssignableFrom(domainClass)) continue;
                nameToTemplateMap.put(toolTemplate.getName(), toolTemplate);
            }
        }
        try {
            ContentHandler<?> handler = DomainObjectAdapter.getContentHandler(domainClass);
            String defaultToolName = handler.getDefaultToolName();
            if (nameToTemplateMap.get(defaultToolName) == null) {
                GhidraToolTemplate toolChestTemplate = this.findToolChestToolTemplate(defaultToolName);
                if (toolChestTemplate != null) {
                    nameToTemplateMap.put(toolChestTemplate.getName(), toolChestTemplate);
                } else {
                    GhidraToolTemplate defaultToolTemplate = this.findDefaultToolTemplate(defaultToolName);
                    if (defaultToolTemplate != null) {
                        nameToTemplateMap.put(defaultToolTemplate.getName(), defaultToolTemplate);
                    }
                }
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)e.getMessage());
        }
        Set<ToolTemplate> defaultTools = ToolUtils.getAllApplicationTools();
        for (ToolTemplate toolTemplate : defaultTools) {
            String toolName = toolTemplate.getName();
            if (nameToTemplateMap.get(toolName) != null) continue;
            for (Class<? extends DomainObject> clazz : types = toolTemplate.getSupportedDataTypes()) {
                if (!clazz.isAssignableFrom(domainClass)) continue;
                nameToTemplateMap.put(toolName, toolTemplate);
            }
        }
        return new HashSet<ToolTemplate>(nameToTemplateMap.values());
    }

    private String getToolAssociationPreferenceKey(String contentType) {
        return TOOL_ASSOCIATION_PREFERENCE + SEPARATOR + contentType;
    }

    private String getDefaultToolAssociation(String contentType) {
        try {
            ContentHandler<?> contentHandler = DomainObjectAdapter.getContentHandler(contentType);
            return contentHandler.getDefaultToolName();
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)e.getMessage());
            return null;
        }
    }

    private GhidraToolTemplate findToolChestToolTemplate(String toolName) {
        if (toolName != null) {
            return (GhidraToolTemplate)this.toolChest.getToolTemplate(toolName);
        }
        return null;
    }

    private GhidraToolTemplate findDefaultToolTemplate(String defaultToolName) {
        if (defaultToolName == null) {
            return null;
        }
        Set<ToolTemplate> defaultTools = ToolUtils.getAllApplicationTools();
        for (ToolTemplate toolTemplate : defaultTools) {
            if (!defaultToolName.equals(toolTemplate.getName())) continue;
            return (GhidraToolTemplate)toolTemplate;
        }
        return null;
    }

    @Override
    public PluginTool[] getRunningTools() {
        return this.toolManager.getRunningTools();
    }

    @Override
    public boolean canAutoSave(PluginTool tool) {
        return this.toolManager.canAutoSave(tool);
    }
}

