/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j;

import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import java.util.Objects;

public class MethodHandle {
    public static final int STATIC_PUT = 0;
    public static final int STATIC_GET = 1;
    public static final int INSTANCE_PUT = 2;
    public static final int INSTANCE_GET = 3;
    public static final int INVOKE_STATIC = 4;
    public static final int INVOKE_INSTANCE = 5;
    public static final int INVOKE_CONSTRUCTOR = 6;
    public static final int INVOKE_DIRECT = 7;
    public static final int INVOKE_INTERFACE = 8;
    private final int type;
    private Field field;
    private Method method;

    public MethodHandle(int type, Field field) {
        this.type = type;
        this.field = field;
    }

    public MethodHandle(int type, Method method) {
        this.type = type;
        this.method = method;
    }

    public MethodHandle(int type, Field field, Method method) {
        this.type = type;
        this.field = field;
        this.method = method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodHandle that = (MethodHandle)o;
        if (this.type != that.type) {
            return false;
        }
        if (!Objects.equals(this.field, that.field)) {
            return false;
        }
        return Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        int result = this.type;
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        return result;
    }

    public int getType() {
        return this.type;
    }

    public Field getField() {
        return this.field;
    }

    public Method getMethod() {
        return this.method;
    }

    public static int getTypeFromAsmOpcode(int opcode) {
        switch (opcode) {
            case 1: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 8;
            }
        }
        throw new RuntimeException("Not supported yet.");
    }
}

