/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.windows;

import com.sun.jna.LastErrorException;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.ptr.IntByReference;
import ghidra.pty.windows.Handle;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class HandleOutputStream
extends OutputStream {
    private final Handle handle;
    private boolean closed = false;

    public HandleOutputStream(Handle handle) {
        this.handle = handle;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        IntByReference dwWritten;
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        int total = 0;
        do {
            dwWritten = new IntByReference();
            if (Kernel32.INSTANCE.WriteFile(this.handle.getNative(), b, b.length, dwWritten, null)) continue;
            throw new IOException("Could not write", new LastErrorException(Kernel32.INSTANCE.GetLastError()));
        } while ((total += dwWritten.getValue()) < b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.write(Arrays.copyOfRange(b, off, off + len));
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
    }

    protected boolean isBuffered() {
        return true;
    }

    @Override
    public void flush() throws IOException {
        if (!this.isBuffered()) {
            return;
        }
        if (!Kernel32.INSTANCE.FlushFileBuffers(this.handle.getNative())) {
            throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
        }
    }
}

