/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dtb;

import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;

public final class DtbUtil {
    public static final boolean isCorrectProcessor(Program program, MessageLog log) {
        Language language = program.getLanguage();
        if (language.getProcessor() == Processor.findOrPossiblyCreateProcessor((String)"DATA") && language.isBigEndian()) {
            return true;
        }
        log.appendMsg(program.getName() + " must use \"Data Big-Endian\" processor module.");
        return false;
    }

    public static final boolean isCorrectLoader(Program program) {
        return "Raw Binary".equals(program.getExecutableFormat());
    }
}

