/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dtb;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.dtb.DtbUtil;
import ghidra.file.formats.dtb.FdtConstants;
import ghidra.file.formats.dtb.FdtHeader;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;

public class FdtAnalyzer
extends FileFormatAnalyzer {
    public String getName() {
        return "Flattened Device Tree (FDT/DTB/DTBO) Analyzer";
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Analyzes Flattened Device Tree (FDT) files.";
    }

    public boolean canAnalyze(Program program) {
        try {
            if (DtbUtil.isCorrectLoader(program)) {
                Address address = this.toAddr(program, 0L);
                byte[] magicBytes = new byte[4];
                program.getMemory().getBytes(address, magicBytes);
                return Arrays.equals(magicBytes, FdtConstants.FDT_MAGIC_BYTES);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isPrototype() {
        return false;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        if (!DtbUtil.isCorrectProcessor(program, log)) {
            return false;
        }
        try (MemoryByteProvider provider = MemoryByteProvider.createProgramHeaderByteProvider((Program)program, (boolean)true);){
            BinaryReader reader = new BinaryReader((ByteProvider)provider, !program.getLanguage().isBigEndian());
            Address address = program.getMinAddress();
            while (true) {
                monitor.checkCancelled();
                if (address.compareTo((Object)program.getMaxAddress()) >= 0) {
                    break;
                }
                reader.setPointerIndex(address.getOffset());
                FdtHeader fdtHeader = new FdtHeader(reader);
                fdtHeader.markup(address, program, monitor, log);
                address = address.add((long)fdtHeader.getTotalSize());
            }
        }
        return true;
    }
}

