/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.ibootim;

import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.ios.ibootim.iBootImConstants;
import ghidra.file.formats.ios.ibootim.iBootImHeader;
import ghidra.file.formats.lzss.LzssCodec;
import ghidra.file.image.GImage;
import ghidra.file.image.GImageFormat;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.GIconProvider;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.StringUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;

@FileSystemInfo(type="ibootim", description="iOS iBootIm", factory=GFileSystemBaseFactory.class)
public class iBootImFileSystem
extends GFileSystemBase
implements GIconProvider {
    private iBootImHeader header;
    private List<GFile> fileList = new ArrayList<GFile>();
    private byte[] bytes = new byte[0];

    public iBootImFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public void close() throws IOException {
        this.bytes = new byte[0];
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) {
        return new ByteArrayProvider(this.bytes, file.getFSRL());
    }

    public Icon getIcon(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        try (ByteArrayInputStream cacheInputStream = new ByteArrayInputStream(this.bytes);){
            GImageFormat format = this.header.getFormat() == 1634887522 ? GImageFormat.RGB_ALPHA_4BYTE : GImageFormat.GRAY_ALPHA_2BYTE;
            GImage image = new GImage(this.header.getWidth(), this.header.getHeight(), format, cacheInputStream, this.bytes.length);
            Icon icon = image.toPNG();
            return icon;
        }
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null || directory.equals((Object)this.root)) {
            return this.fileList;
        }
        return new ArrayList<GFile>();
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        byte[] signatureBytes = this.provider.readBytes(0L, 8L);
        return Arrays.equals(signatureBytes, iBootImConstants.SIGNATURE_BYTES);
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        monitor.setMessage("Opening iBoot Image...");
        this.header = new iBootImHeader(this.provider);
        byte[] compressedBytes = this.provider.readBytes(64L, this.provider.length() - 64L);
        ByteArrayOutputStream decompressedBytes = new ByteArrayOutputStream();
        LzssCodec.decompress(decompressedBytes, new ByteArrayInputStream(compressedBytes));
        this.bytes = decompressedBytes.toByteArray();
        String name = StringUtilities.toString((int)this.header.getFormat()) + "_image";
        GFileImpl file = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)name, (boolean)false, (long)decompressedBytes.size(), null);
        this.fileList.add((GFile)file);
    }
}

