/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.squashfs.SquashInode;
import ghidra.file.formats.squashfs.SquashSuperBlock;
import java.io.IOException;

public class SquashSymlinkInode
extends SquashInode {
    private long linkCount;
    private String targetPath;
    private long xattrIndex;

    public SquashSymlinkInode(BinaryReader reader, SquashSuperBlock superBlock, boolean isExtended) throws IOException {
        super(reader, superBlock);
        this.linkCount = reader.readNextUnsignedInt();
        int targetSize = reader.readNextInt();
        this.targetPath = reader.readNextAsciiString(targetSize);
        if (isExtended) {
            this.xattrIndex = reader.readNextUnsignedInt();
        }
    }

    public long getLinkCount() {
        return this.linkCount;
    }

    public String getPath() {
        return this.targetPath;
    }

    public long getXattrIndex() {
        return this.xattrIndex;
    }
}

