/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderInputStream;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.gzip.GZipConstants;
import ghidra.file.formats.squashfs.SquashBasicDirectoryInode;
import ghidra.file.formats.squashfs.SquashBasicFileInode;
import ghidra.file.formats.squashfs.SquashConstants;
import ghidra.file.formats.squashfs.SquashDirectoryTable;
import ghidra.file.formats.squashfs.SquashDirectoryTableEntry;
import ghidra.file.formats.squashfs.SquashDirectoryTableHeader;
import ghidra.file.formats.squashfs.SquashFragment;
import ghidra.file.formats.squashfs.SquashFragmentTable;
import ghidra.file.formats.squashfs.SquashInode;
import ghidra.file.formats.squashfs.SquashInodeTable;
import ghidra.file.formats.squashfs.SquashMetablock;
import ghidra.file.formats.squashfs.SquashSymlinkInode;
import ghidra.file.formats.squashfs.SquashedFile;
import ghidra.formats.gfilesystem.FileSystemIndexHelper;
import ghidra.formats.gfilesystem.GFile;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.tukaani.xz.LZMAInputStream;

public class SquashUtils {
    public static boolean isSquashFS(byte[] bytes) {
        return bytes.length >= GZipConstants.MAGIC_BYTES.length && bytes[0] == SquashConstants.MAGIC[0] && bytes[1] == SquashConstants.MAGIC[1] && bytes[2] == SquashConstants.MAGIC[2] && bytes[3] == SquashConstants.MAGIC[3];
    }

    public static byte[] decompressBlock(BinaryReader reader, int compressionType, TaskMonitor monitor) throws IOException, CancelledException {
        SquashMetablock header = new SquashMetablock(reader);
        if (header.isCompressed()) {
            return SquashUtils.decompressBytes(reader, header.getBlockSize(), compressionType, monitor);
        }
        return reader.readNextByteArray((int)header.getBlockSize());
    }

    public static BinaryReader byteArrayToReader(byte[] bytes) {
        ByteArrayProvider newProvider = new ByteArrayProvider(bytes);
        return new BinaryReader((ByteProvider)newProvider, true);
    }

    public static byte[] decompressBytes(BinaryReader reader, int length, int compressionType, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.checkCancelled();
        try (InputStream is = SquashUtils.getSubInputStream(reader, length);){
            byte[] byArray;
            block9: {
                InputStream decompressedInputStream = SquashUtils.getDecompressionStream(is, compressionType);
                try {
                    byArray = decompressedInputStream.readAllBytes();
                    if (decompressedInputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    if (decompressedInputStream != null) {
                        try {
                            decompressedInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                decompressedInputStream.close();
            }
            return byArray;
        }
    }

    public static InputStream getSubInputStream(BinaryReader reader, long length) {
        long start = reader.getPointerIndex();
        reader.setPointerIndex(start + length);
        ByteProvider bp = reader.getByteProvider();
        ByteProviderWrapper subBP = new ByteProviderWrapper(bp, start, length);
        return new ByteProviderInputStream.ClosingInputStream((ByteProvider)subBP);
    }

    public static InputStream getDecompressionStream(InputStream is, int compressionType) throws IOException {
        switch (compressionType) {
            case 1: {
                return new DeflateCompressorInputStream(is);
            }
            case 2: {
                LZMAInputStream lzmaIn = new LZMAInputStream(is);
                lzmaIn.enableRelaxedEndCondition();
                return lzmaIn;
            }
            case 3: {
                throw new IOException("LZO compression is not supported");
            }
            case 4: {
                return new XZCompressorInputStream(is);
            }
            case 5: {
                return new BlockLZ4CompressorInputStream(is);
            }
            case 6: {
                throw new IOException("ZSTD compression is not supported");
            }
        }
        throw new IOException("Supplied compression type (code: " + compressionType + ") was not recognized. ");
    }

    public static void buildDirectoryStructure(SquashFragmentTable fragTable, SquashDirectoryTable dirTable, SquashInodeTable inodes, FileSystemIndexHelper<SquashedFile> fsih, TaskMonitor monitor) throws CancelledException, IOException {
        SquashInode[] inodeArray = inodes.getInodes();
        SquashInode rootInode = inodes.getRootInode();
        if (rootInode != null && rootInode.isDir()) {
            SquashBasicDirectoryInode dirInode = (SquashBasicDirectoryInode)rootInode;
            List<SquashDirectoryTableHeader> headers = dirTable.getHeaders(dirInode);
            if (headers.size() == 0) {
                throw new IOException("Unable to find headers for the root directory");
            }
            for (SquashDirectoryTableHeader header : headers) {
                List<SquashDirectoryTableEntry> entries = header.getEntries();
                for (SquashDirectoryTableEntry entry : entries) {
                    SquashUtils.assignPathsRecursively(fragTable, dirTable, entry, inodeArray, fsih.getRootDir(), fsih, monitor);
                }
            }
        } else {
            throw new IOException("Root inode was not a directory!");
        }
    }

    private static void assignPathsRecursively(SquashFragmentTable fragTable, SquashDirectoryTable dirTable, SquashDirectoryTableEntry entry, SquashInode[] inodes, GFile parentDir, FileSystemIndexHelper<SquashedFile> fsih, TaskMonitor monitor) throws CancelledException, IOException {
        monitor.checkCancelled();
        if (entry == null || entry.getInodeNumber() < 1 || entry.getInodeNumber() > inodes.length) {
            throw new IOException("Entry found with invalid inode number: " + entry.getInodeNumber());
        }
        SquashInode inode = inodes[entry.getInodeNumber()];
        if (inode.isDir()) {
            SquashBasicDirectoryInode dirInode = (SquashBasicDirectoryInode)inode;
            SquashedFile squashedDirFile = new SquashedFile(dirInode, null);
            GFile dirGFile = fsih.storeFileWithParent(entry.getFileName(), parentDir, (long)inode.getNumber(), true, -1L, (Object)squashedDirFile);
            List<SquashDirectoryTableHeader> headers = dirTable.getHeaders(dirInode);
            for (SquashDirectoryTableHeader header : headers) {
                List<SquashDirectoryTableEntry> entries = header.getEntries();
                for (SquashDirectoryTableEntry currentEntry : entries) {
                    SquashUtils.assignPathsRecursively(fragTable, dirTable, currentEntry, inodes, dirGFile, fsih, monitor);
                }
            }
        } else if (inode.isFile()) {
            SquashBasicFileInode fileInode = (SquashBasicFileInode)inode;
            SquashFragment fragment = fragTable.getFragment(fileInode.getFragmentIndex());
            fsih.storeFileWithParent(entry.getFileName(), parentDir, (long)fileInode.getNumber(), false, fileInode.getFileSize(), (Object)new SquashedFile(fileInode, fragment));
        } else if (inode.isSymLink()) {
            SquashSymlinkInode symLinkInode = (SquashSymlinkInode)inode;
            fsih.storeSymlinkWithParent(entry.getFileName(), parentDir, (long)symLinkInode.getNumber(), symLinkInode.getPath(), 0L, (Object)new SquashedFile(symLinkInode, null));
        } else {
            Msg.info(SquashUtils.class, (Object)("Inode #" + inode.getNumber() + " is not a file or directory. Skipping..."));
        }
    }
}

