/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.AbstractOptions;
import ghidra.framework.options.ActionTrigger;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.GProperties;
import ghidra.framework.options.JSonProperties;
import ghidra.framework.options.Option;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.SaveState;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import javax.swing.KeyStroke;
import org.apache.commons.io.FilenameUtils;

public class FileOptions
extends AbstractOptions {
    private File file;

    public FileOptions(String name) {
        super(name);
    }

    public FileOptions(File file) throws IOException {
        this(FilenameUtils.getBaseName((String)file.getName()));
        this.file = file;
        this.loadFromFile();
    }

    public void save(File saveFile) throws IOException {
        this.name = FilenameUtils.getBaseName((String)saveFile.getName());
        this.file = saveFile;
        this.saveToFile();
    }

    public File getFile() {
        return this.file;
    }

    public CustomOption readCustomOption(GProperties properties) {
        String customOptionClassName = properties.getString("CUSTOM_OPTION_CLASS", null);
        try {
            Class<?> c = Class.forName(customOptionClassName);
            CustomOption customOption = (CustomOption)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            customOption.readState(properties);
            return customOption;
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Can't create customOption instance for: " + customOptionClassName), (Throwable)e);
            return null;
        }
    }

    private void loadFromFile() throws IOException {
        JSonProperties properties = new JSonProperties(this.file);
        for (String optionName : properties.getNames()) {
            Object object = properties.getObject(optionName);
            if (object instanceof GProperties) {
                GProperties customState = (GProperties)object;
                object = this.readCustomOption(customState);
            }
            Option option = this.createUnregisteredOption(optionName, OptionType.getOptionType(object), null);
            option.doSetCurrentValue(object);
            this.valueMap.put(optionName, option);
        }
    }

    private void saveToFile() throws IOException {
        SaveState saveState = new SaveState("File_Options");
        for (String optionName : this.valueMap.keySet()) {
            Option optionValue = (Option)this.valueMap.get(optionName);
            if (optionValue.isDefault()) continue;
            Object value = optionValue.getValue(null);
            if (value instanceof CustomOption) {
                SaveState customState = new SaveState();
                customState.putString("CUSTOM_OPTION_CLASS", value.getClass().getName());
                ((CustomOption)value).writeState((GProperties)customState);
                value = customState;
            }
            saveState.putObject(optionName, value);
        }
        saveState.saveToJsonFile(this.file);
    }

    @Override
    protected Option createRegisteredOption(String optionName, OptionType type, String description, HelpLocation help, Object defaultValue, PropertyEditor editor) {
        return new FileOption(optionName, type, description, help, defaultValue, true, editor);
    }

    @Override
    protected Option createUnregisteredOption(String optionName, OptionType type, Object defaultValue) {
        if (type == OptionType.KEYSTROKE_TYPE) {
            type = OptionType.ACTION_TRIGGER;
            if (defaultValue instanceof KeyStroke) {
                KeyStroke keyStroke = (KeyStroke)defaultValue;
                defaultValue = new ActionTrigger(keyStroke);
            }
        }
        return new FileOption(optionName, type, null, null, defaultValue, false, null);
    }

    @Override
    protected boolean notifyOptionChanged(String optionName, Object oldValue, Object newValue) {
        return true;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public FileOptions copy() {
        FileOptions copy = new FileOptions("new");
        for (String optionName : this.valueMap.keySet()) {
            Option optionValue = (Option)this.valueMap.get(optionName);
            if (optionValue.isDefault()) continue;
            Object value = optionValue.getValue(null);
            copy.putObject(optionName, value);
        }
        return copy;
    }

    private static class FileOption
    extends Option {
        private Object currentValue;

        FileOption(String name, OptionType type, String description, HelpLocation helpLocation, Object defaultValue, boolean isRegistered, PropertyEditor editor) {
            super(name, type, description, helpLocation, defaultValue, isRegistered, editor);
            this.currentValue = defaultValue;
        }

        @Override
        public Object getCurrentValue() {
            return this.currentValue;
        }

        @Override
        public void doSetCurrentValue(Object value) {
            this.currentValue = value;
        }
    }
}

