/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.OptionType;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.WrappedOption;
import java.util.Date;

public class WrappedDate
implements WrappedOption {
    private static final String DATE = "date";
    private Date date;

    public String toString() {
        return "WrappedDate: " + String.valueOf(this.date);
    }

    public WrappedDate(Date date) {
        this.date = date;
    }

    public WrappedDate() {
    }

    @Override
    public void readState(SaveState saveState) {
        long time = saveState.getLong(DATE, 0L);
        this.date = new Date(time);
    }

    @Override
    public void writeState(SaveState saveState) {
        saveState.putLong(DATE, this.date.getTime());
    }

    @Override
    public Object getObject() {
        return this.date;
    }

    @Override
    public OptionType getOptionType() {
        return OptionType.DATE_TYPE;
    }
}

