/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.pcode.emu.jit.analysis.JitAnalysisContext;
import ghidra.pcode.emu.jit.analysis.JitDataFlowModel;
import ghidra.pcode.emu.jit.analysis.JitDataFlowState;
import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.op.JitCallOtherDefOp;
import ghidra.pcode.emu.jit.op.JitCallOtherOp;
import ghidra.pcode.emu.jit.op.JitNopOp;
import ghidra.pcode.emu.jit.var.JitOutVar;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JitDataFlowUseropLibrary
implements PcodeUseropLibrary<JitVal> {
    private final JitDataFlowModel dfm;
    private final Map<String, PcodeUseropLibrary.PcodeUseropDefinition<JitVal>> userops;

    public JitDataFlowUseropLibrary(JitAnalysisContext context, JitDataFlowModel dfm) {
        this.dfm = dfm;
        this.userops = context.getPassage().getDecodeLibrary().getUserops().values().stream().map(x$0 -> new WrappedUseropDefinition((PcodeUseropLibrary.PcodeUseropDefinition<Object>)x$0)).collect(Collectors.toUnmodifiableMap(d -> d.getName(), d -> d));
    }

    @Override
    public Map<String, PcodeUseropLibrary.PcodeUseropDefinition<JitVal>> getUserops() {
        return this.userops;
    }

    protected class WrappedUseropDefinition
    implements PcodeUseropLibrary.PcodeUseropDefinition<JitVal> {
        private final PcodeUseropLibrary.PcodeUseropDefinition<Object> decOp;

        public WrappedUseropDefinition(PcodeUseropLibrary.PcodeUseropDefinition<Object> decOp) {
            this.decOp = decOp;
        }

        @Override
        public String getName() {
            return this.decOp.getName();
        }

        @Override
        public int getInputCount() {
            return this.decOp.getInputCount();
        }

        @Override
        public void execute(PcodeExecutor<JitVal> executor, PcodeUseropLibrary<JitVal> library, Varnode outVar, List<Varnode> inVars) {
            throw new AssertionError();
        }

        private List<JitTypeBehavior> getInputTypes(List<JitVal> inVals) {
            int inputCount = this.getInputCount();
            if (inputCount != inVals.size()) {
                return JitDataFlowModel.allAny(inVals);
            }
            Method method = this.decOp.getJavaMethod();
            if (method == null) {
                return JitDataFlowModel.allAny(inVals);
            }
            ArrayList<JitTypeBehavior> result = new ArrayList<JitTypeBehavior>();
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < inVals.size(); ++i) {
                Parameter p = parameters[i];
                JitTypeBehavior type = JitTypeBehavior.forJavaType(p.getType());
                if (type == null) {
                    return JitDataFlowModel.allAny(inVals);
                }
                result.add(type);
            }
            return Collections.unmodifiableList(result);
        }

        private JitTypeBehavior getReturnType() {
            Method method = this.decOp.getJavaMethod();
            if (method == null) {
                return JitTypeBehavior.ANY;
            }
            return JitTypeBehavior.forJavaType(method.getReturnType());
        }

        @Override
        public void execute(PcodeExecutor<JitVal> executor, PcodeUseropLibrary<JitVal> library, PcodeOp op) {
            if (this.decOp.canInlinePcode()) {
                JitDataFlowUseropLibrary.this.dfm.notifyOp(new JitNopOp(op));
                return;
            }
            JitDataFlowState state = (JitDataFlowState)executor.getState();
            List<JitVal> inVals = Stream.of(op.getInputs()).skip(1L).map(inVn -> (JitVal)state.getVar((Varnode)inVn, executor.getReason())).toList();
            List<JitTypeBehavior> inTypes = this.getInputTypes(inVals);
            Varnode outVn = op.getOutput();
            if (outVn == null) {
                JitDataFlowUseropLibrary.this.dfm.notifyOp(new JitCallOtherOp(op, this.decOp, inVals, inTypes, state.captureState()));
            } else {
                JitOutVar out = JitDataFlowUseropLibrary.this.dfm.generateOutVar(outVn);
                JitDataFlowUseropLibrary.this.dfm.notifyOp(new JitCallOtherDefOp(op, out, this.getReturnType(), this.decOp, inVals, inTypes, state.captureState()));
                state.setVar(outVn, out);
            }
        }

        @Override
        public boolean isFunctional() {
            return this.decOp.isFunctional();
        }

        @Override
        public boolean hasSideEffects() {
            return this.decOp.hasSideEffects();
        }

        @Override
        public boolean modifiesContext() {
            return this.decOp.modifiesContext();
        }

        @Override
        public boolean canInlinePcode() {
            return this.decOp.canInlinePcode();
        }

        @Override
        public Method getJavaMethod() {
            return this.decOp.getJavaMethod();
        }

        @Override
        public PcodeUseropLibrary<?> getDefiningLibrary() {
            return this.decOp.getDefiningLibrary();
        }
    }
}

