/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.lifecycle.Unfinished;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.BinOpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitIntTestOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public interface CompareIntBinOpGen<T extends JitIntTestOp>
extends BinOpGen<T> {
    public boolean isSigned();

    public int icmpOpcode();

    default public void generateIntJump(Label lblTrue, MethodVisitor rv) {
        if (this.isSigned()) {
            rv.visitJumpInsn(this.icmpOpcode(), lblTrue);
        } else {
            rv.visitMethodInsn(184, GenConsts.NAME_INTEGER, "compareUnsigned", GenConsts.MDESC_INTEGER__COMPARE_UNSIGNED, false);
            rv.visitJumpInsn(this.ifOpcode(), lblTrue);
        }
    }

    default public void generateLongJump(Label lblTrue, MethodVisitor rv) {
        if (this.isSigned()) {
            rv.visitInsn(148);
        } else {
            rv.visitMethodInsn(184, GenConsts.NAME_LONG, "compareUnsigned", GenConsts.MDESC_LONG__COMPARE_UNSIGNED, false);
        }
        rv.visitJumpInsn(this.ifOpcode(), lblTrue);
    }

    public int ifOpcode();

    @Override
    default public JitType afterLeft(JitCodeGenerator gen, T op, JitType lType, JitType rType, MethodVisitor rv) {
        return TypeConversions.forceUniformZExt(lType, rType, rv);
    }

    @Override
    default public JitType generateBinOpRunCode(JitCodeGenerator gen, T op, JitControlFlowModel.JitBlock block, JitType lType, JitType rType, MethodVisitor rv) {
        Label lblTrue = new Label();
        Label lblDone = new Label();
        JitType jitType = rType = TypeConversions.forceUniformZExt(rType, lType, rv);
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.IntJitType t = (JitType.IntJitType)jitType2;
                this.generateIntJump(lblTrue, rv);
                break;
            }
            case 1: {
                JitType.LongJitType t = (JitType.LongJitType)jitType2;
                this.generateLongJump(lblTrue, rv);
                break;
            }
            case 2: {
                JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                Unfinished.TODO((String)"MpInt", (Object[])new Object[0]);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        JitType outType = op.type().resolve(gen.getTypeModel().typeOf(op.out()));
        TypeConversions.generateLdcFalse(outType, rv);
        rv.visitJumpInsn(167, lblDone);
        rv.visitLabel(lblTrue);
        TypeConversions.generateLdcTrue(outType, rv);
        rv.visitLabel(lblDone);
        return outType;
    }
}

