/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.tgt;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.JitPcodeThread;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassageClass;
import ghidra.pcode.exec.DecodePcodeExecutionException;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.util.DefaultLanguageService;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public interface JitCompiledPassage {
    public EntryPoint run(int var1);

    public static int readInt1(byte[] arr, int offset) {
        return Byte.toUnsignedInt(arr[offset]);
    }

    public static int readIntBE2(byte[] arr, int offset) {
        return Byte.toUnsignedInt(arr[offset]) << 8 | Byte.toUnsignedInt(arr[offset + 1]);
    }

    public static int readIntBE3(byte[] arr, int offset) {
        return Byte.toUnsignedInt(arr[offset]) << 16 | Byte.toUnsignedInt(arr[offset + 1]) << 8 | Byte.toUnsignedInt(arr[offset + 2]);
    }

    public static int readIntBE4(byte[] arr, int offset) {
        return Byte.toUnsignedInt(arr[offset]) << 24 | Byte.toUnsignedInt(arr[offset + 1]) << 16 | Byte.toUnsignedInt(arr[offset + 2]) << 8 | Byte.toUnsignedInt(arr[offset + 3]);
    }

    public static int readIntLE2(byte[] arr, int offset) {
        return Byte.toUnsignedInt(arr[offset]) | Byte.toUnsignedInt(arr[offset + 1]) << 8;
    }

    public static int readIntLE3(byte[] arr, int offset) {
        return Byte.toUnsignedInt(arr[offset]) | Byte.toUnsignedInt(arr[offset + 1]) << 8 | Byte.toUnsignedInt(arr[offset + 2]) << 16;
    }

    public static int readIntLE4(byte[] arr, int offset) {
        return Byte.toUnsignedInt(arr[offset]) | Byte.toUnsignedInt(arr[offset + 1]) << 8 | Byte.toUnsignedInt(arr[offset + 2]) << 16 | Byte.toUnsignedInt(arr[offset + 3]) << 24;
    }

    public static void writeInt1(int value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
    }

    public static void writeIntBE2(int value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 8);
        arr[offset + 1] = (byte)value;
    }

    public static void writeIntBE3(int value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 16);
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)value;
    }

    public static void writeIntBE4(int value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 24);
        arr[offset + 1] = (byte)(value >> 16);
        arr[offset + 2] = (byte)(value >> 8);
        arr[offset + 3] = (byte)value;
    }

    public static void writeIntLE2(int value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
    }

    public static void writeIntLE3(int value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
    }

    public static void writeIntLE4(int value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
        arr[offset + 3] = (byte)(value >> 24);
    }

    public static long readLong1(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]);
    }

    public static long readLongBE2(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) << 8 | Byte.toUnsignedLong(arr[offset + 1]);
    }

    public static long readLongBE3(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) << 16 | Byte.toUnsignedLong(arr[offset + 1]) << 8 | Byte.toUnsignedLong(arr[offset + 2]);
    }

    public static long readLongBE4(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) << 24 | Byte.toUnsignedLong(arr[offset + 1]) << 16 | Byte.toUnsignedLong(arr[offset + 2]) << 8 | Byte.toUnsignedLong(arr[offset + 3]);
    }

    public static long readLongBE5(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) << 32 | Byte.toUnsignedLong(arr[offset + 1]) << 24 | Byte.toUnsignedLong(arr[offset + 2]) << 16 | Byte.toUnsignedLong(arr[offset + 3]) << 8 | Byte.toUnsignedLong(arr[offset + 4]);
    }

    public static long readLongBE6(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) << 40 | Byte.toUnsignedLong(arr[offset + 1]) << 32 | Byte.toUnsignedLong(arr[offset + 2]) << 24 | Byte.toUnsignedLong(arr[offset + 3]) << 16 | Byte.toUnsignedLong(arr[offset + 4]) << 8 | Byte.toUnsignedLong(arr[offset + 5]);
    }

    public static long readLongBE7(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) << 48 | Byte.toUnsignedLong(arr[offset + 1]) << 40 | Byte.toUnsignedLong(arr[offset + 2]) << 32 | Byte.toUnsignedLong(arr[offset + 3]) << 24 | Byte.toUnsignedLong(arr[offset + 4]) << 16 | Byte.toUnsignedLong(arr[offset + 5]) << 8 | Byte.toUnsignedLong(arr[offset + 6]);
    }

    public static long readLongBE8(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) << 56 | Byte.toUnsignedLong(arr[offset + 1]) << 48 | Byte.toUnsignedLong(arr[offset + 2]) << 40 | Byte.toUnsignedLong(arr[offset + 3]) << 32 | Byte.toUnsignedLong(arr[offset + 4]) << 24 | Byte.toUnsignedLong(arr[offset + 5]) << 16 | Byte.toUnsignedLong(arr[offset + 6]) << 8 | Byte.toUnsignedLong(arr[offset + 7]);
    }

    public static long readLongLE2(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) | Byte.toUnsignedLong(arr[offset + 1]) << 8;
    }

    public static long readLongLE3(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) | Byte.toUnsignedLong(arr[offset + 1]) << 8 | Byte.toUnsignedLong(arr[offset + 2]) << 16;
    }

    public static long readLongLE4(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) | Byte.toUnsignedLong(arr[offset + 1]) << 8 | Byte.toUnsignedLong(arr[offset + 2]) << 16 | Byte.toUnsignedLong(arr[offset + 3]) << 24;
    }

    public static long readLongLE5(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) | Byte.toUnsignedLong(arr[offset + 1]) << 8 | Byte.toUnsignedLong(arr[offset + 2]) << 16 | Byte.toUnsignedLong(arr[offset + 3]) << 24 | Byte.toUnsignedLong(arr[offset + 4]) << 32;
    }

    public static long readLongLE6(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) | Byte.toUnsignedLong(arr[offset + 1]) << 8 | Byte.toUnsignedLong(arr[offset + 2]) << 16 | Byte.toUnsignedLong(arr[offset + 3]) << 24 | Byte.toUnsignedLong(arr[offset + 4]) << 32 | Byte.toUnsignedLong(arr[offset + 5]) << 40;
    }

    public static long readLongLE7(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) | Byte.toUnsignedLong(arr[offset + 1]) << 8 | Byte.toUnsignedLong(arr[offset + 2]) << 16 | Byte.toUnsignedLong(arr[offset + 3]) << 24 | Byte.toUnsignedLong(arr[offset + 4]) << 32 | Byte.toUnsignedLong(arr[offset + 5]) << 40 | Byte.toUnsignedLong(arr[offset + 6]) << 48;
    }

    public static long readLongLE8(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) | Byte.toUnsignedLong(arr[offset + 1]) << 8 | Byte.toUnsignedLong(arr[offset + 2]) << 16 | Byte.toUnsignedLong(arr[offset + 3]) << 24 | Byte.toUnsignedLong(arr[offset + 4]) << 32 | Byte.toUnsignedLong(arr[offset + 5]) << 40 | Byte.toUnsignedLong(arr[offset + 6]) << 48 | Byte.toUnsignedLong(arr[offset + 7]) << 56;
    }

    public static void writeLong1(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
    }

    public static void writeLongBE2(long value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 8);
        arr[offset + 1] = (byte)value;
    }

    public static void writeLongBE3(long value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 16);
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)value;
    }

    public static void writeLongBE4(long value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 24);
        arr[offset + 1] = (byte)(value >> 16);
        arr[offset + 2] = (byte)(value >> 8);
        arr[offset + 3] = (byte)value;
    }

    public static void writeLongBE5(long value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 32);
        arr[offset + 1] = (byte)(value >> 24);
        arr[offset + 2] = (byte)(value >> 16);
        arr[offset + 3] = (byte)(value >> 8);
        arr[offset + 4] = (byte)value;
    }

    public static void writeLongBE6(long value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 40);
        arr[offset + 1] = (byte)(value >> 32);
        arr[offset + 2] = (byte)(value >> 24);
        arr[offset + 3] = (byte)(value >> 16);
        arr[offset + 4] = (byte)(value >> 8);
        arr[offset + 5] = (byte)value;
    }

    public static void writeLongBE7(long value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 48);
        arr[offset + 1] = (byte)(value >> 40);
        arr[offset + 2] = (byte)(value >> 32);
        arr[offset + 3] = (byte)(value >> 24);
        arr[offset + 4] = (byte)(value >> 16);
        arr[offset + 5] = (byte)(value >> 8);
        arr[offset + 6] = (byte)value;
    }

    public static void writeLongBE8(long value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 56);
        arr[offset + 1] = (byte)(value >> 48);
        arr[offset + 2] = (byte)(value >> 40);
        arr[offset + 3] = (byte)(value >> 32);
        arr[offset + 4] = (byte)(value >> 24);
        arr[offset + 5] = (byte)(value >> 16);
        arr[offset + 6] = (byte)(value >> 8);
        arr[offset + 7] = (byte)value;
    }

    public static void writeLongLE2(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
    }

    public static void writeLongLE3(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
    }

    public static void writeLongLE4(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
        arr[offset + 3] = (byte)(value >> 24);
    }

    public static void writeLongLE5(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
        arr[offset + 3] = (byte)(value >> 24);
        arr[offset + 4] = (byte)(value >> 32);
    }

    public static void writeLongLE6(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
        arr[offset + 3] = (byte)(value >> 24);
        arr[offset + 4] = (byte)(value >> 32);
        arr[offset + 5] = (byte)(value >> 40);
    }

    public static void writeLongLE7(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
        arr[offset + 3] = (byte)(value >> 24);
        arr[offset + 4] = (byte)(value >> 32);
        arr[offset + 5] = (byte)(value >> 40);
        arr[offset + 6] = (byte)(value >> 48);
    }

    public static void writeLongLE8(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
        arr[offset + 3] = (byte)(value >> 24);
        arr[offset + 4] = (byte)(value >> 32);
        arr[offset + 5] = (byte)(value >> 40);
        arr[offset + 6] = (byte)(value >> 48);
        arr[offset + 7] = (byte)(value >> 56);
    }

    public static long conv2IntToLong(int msl, int lsl) {
        return Integer.toUnsignedLong(msl) << 32 | Integer.toUnsignedLong(lsl);
    }

    public static int sBorrowIntRaw(int a, int b) {
        int r = a - b;
        a ^= r;
        r ^= b;
        return a &= (r ^= 0xFFFFFFFF);
    }

    public static long sBorrowLongRaw(long a, long b) {
        long r = a - b;
        a ^= r;
        r ^= b;
        return a &= (r ^= 0xFFFFFFFFFFFFFFFFL);
    }

    public static int sCarryIntRaw(int a, int b) {
        int r = a + b;
        r ^= a;
        a ^= b;
        return r &= (a ^= 0xFFFFFFFF);
    }

    public static long sCarryLongRaw(long a, long b) {
        long r = a + b;
        r ^= a;
        a ^= b;
        return r &= (a ^= 0xFFFFFFFFFFFFFFFFL);
    }

    public static long intLeft(long val, long amt) {
        if (Long.compareUnsigned(amt, 64L) >= 0) {
            return 0L;
        }
        return val << (int)amt;
    }

    public static long intLeft(long val, int amt) {
        if (Integer.compareUnsigned(amt, 64) >= 0) {
            return 0L;
        }
        return val << amt;
    }

    public static int intLeft(int val, long amt) {
        if (Long.compareUnsigned(amt, 32L) >= 0) {
            return 0;
        }
        return val << (int)amt;
    }

    public static int intLeft(int val, int amt) {
        if (Long.compareUnsigned(amt, 32L) >= 0) {
            return 0;
        }
        return val << amt;
    }

    public static long intRight(long val, long amt) {
        if (Long.compareUnsigned(amt, 64L) >= 0) {
            return 0L;
        }
        return val >>> (int)amt;
    }

    public static long intRight(long val, int amt) {
        if (Integer.compareUnsigned(amt, 64) >= 0) {
            return 0L;
        }
        return val >>> amt;
    }

    public static int intRight(int val, long amt) {
        if (Long.compareUnsigned(amt, 32L) >= 0) {
            return 0;
        }
        return val >>> (int)amt;
    }

    public static int intRight(int val, int amt) {
        if (Long.compareUnsigned(amt, 32L) >= 0) {
            return 0;
        }
        return val >>> amt;
    }

    public static long intSRight(long val, long amt) {
        if (Long.compareUnsigned(amt, 64L) >= 0) {
            return val >> 63;
        }
        return val >> (int)amt;
    }

    public static long intSRight(long val, int amt) {
        if (Integer.compareUnsigned(amt, 64) >= 0) {
            return val >> 63;
        }
        return val >> amt;
    }

    public static int intSRight(int val, long amt) {
        if (Long.compareUnsigned(amt, 32L) >= 0) {
            return val >> 31;
        }
        return val >> (int)amt;
    }

    public static int intSRight(int val, int amt) {
        if (Long.compareUnsigned(amt, 32L) >= 0) {
            return val >> 31;
        }
        return val >> amt;
    }

    public static Language getLanguage(String languageID) throws LanguageNotFoundException {
        return DefaultLanguageService.getLanguageService().getLanguage(new LanguageID(languageID));
    }

    public static RegisterValue createContext(Language language, String value) {
        return new RegisterValue(language.getContextBaseRegister(), new BigInteger(value, 16));
    }

    public static Varnode createVarnode(AddressFactory factory, String space, long offset, int size) {
        return new Varnode(factory.getAddressSpace(space).getAddress(offset), size);
    }

    public JitPcodeThread thread();

    default public void writeCounterAndContext(long counter, RegisterValue context) {
        JitPcodeThread thread = this.thread();
        Address pc = thread.getLanguage().getDefaultSpace().getAddress(counter);
        thread.writeCounterAndContext(pc, context);
    }

    default public void setCounterAndContext(long counter, RegisterValue context) {
        JitPcodeThread thread = this.thread();
        Address pc = thread.getLanguage().getDefaultSpace().getAddress(counter);
        thread.setCounterAndContext(pc, context);
    }

    default public PcodeUseropLibrary.PcodeUseropDefinition<byte[]> getUseropDefinition(String name) {
        return this.thread().getUseropLibrary().getUserops().get(name);
    }

    default public void invokeUserop(PcodeUseropLibrary.PcodeUseropDefinition<byte[]> userop, Varnode output, Varnode[] inputs) {
        userop.execute(this.thread().getExecutor(), this.thread().getUseropLibrary(), output, Arrays.asList(inputs));
    }

    default public DecodePcodeExecutionException createDecodeError(String message, long counter) {
        return new DecodePcodeExecutionException(message, this.thread().getLanguage().getDefaultSpace().getAddress(counter));
    }

    default public ExitSlot createExitSlot(long target, RegisterValue ctx) {
        return new ExitSlot(this.thread(), target, ctx);
    }

    public static EntryPoint getChained(ExitSlot slot) {
        return slot.getChained();
    }

    default public void count(int instructions, int trailingOps) {
        this.thread().count(instructions, trailingOps);
    }

    public static class ExitSlot {
        private final JitPcodeThread thread;
        private final JitPassage.AddrCtx pcCtx;
        private EntryPoint chained;

        public ExitSlot(JitPcodeThread thread, long target, RegisterValue ctx) {
            this.thread = thread;
            this.pcCtx = new JitPassage.AddrCtx(ctx, thread.getLanguage().getDefaultSpace().getAddress(target));
        }

        public EntryPoint getChained() {
            if (this.chained == null) {
                this.chained = this.computeChained();
            }
            return this.chained;
        }

        private EntryPoint computeChained() {
            return this.thread.getEntry(this.pcCtx);
        }
    }

    public record EntryPoint(EntryPointPrototype prototype, JitCompiledPassage passage, int blockId) {
        public EntryPoint run() {
            return this.passage.run(this.blockId);
        }
    }

    public static class EntryPointPrototype {
        private final JitCompiledPassageClass cls;
        private final int blockId;
        private final Map<JitPcodeThread, EntryPoint> perThread = new HashMap<JitPcodeThread, EntryPoint>();

        public EntryPointPrototype(JitCompiledPassageClass cls, int blockId) {
            this.cls = cls;
            this.blockId = blockId;
        }

        public String toString() {
            return "EntryPointPrototype[%s,%d]".formatted(this.cls, this.blockId);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntryPointPrototype)) {
                return false;
            }
            EntryPointPrototype that = (EntryPointPrototype)obj;
            if (!this.cls.equals(that.cls)) {
                return false;
            }
            return this.blockId == that.blockId;
        }

        public int hashCode() {
            return Objects.hash(this.cls, this.blockId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EntryPoint createInstance(JitPcodeThread thread) {
            Map<JitPcodeThread, EntryPoint> map = this.perThread;
            synchronized (map) {
                return this.perThread.computeIfAbsent(thread, t -> new EntryPoint(this, this.cls.createInstance((JitPcodeThread)t), this.blockId));
            }
        }
    }
}

