/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.var;

import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.analysis.JitVarScopeModel;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.type.TypedAccessGen;
import ghidra.pcode.emu.jit.gen.var.DirectMemoryVarGen;
import ghidra.pcode.emu.jit.gen.var.InputVarGen;
import ghidra.pcode.emu.jit.gen.var.LocalOutVarGen;
import ghidra.pcode.emu.jit.gen.var.MemoryOutVarGen;
import ghidra.pcode.emu.jit.gen.var.MissingVarGen;
import ghidra.pcode.emu.jit.gen.var.ValGen;
import ghidra.pcode.emu.jit.var.JitDirectMemoryVar;
import ghidra.pcode.emu.jit.var.JitIndirectMemoryVar;
import ghidra.pcode.emu.jit.var.JitInputVar;
import ghidra.pcode.emu.jit.var.JitLocalOutVar;
import ghidra.pcode.emu.jit.var.JitMemoryOutVar;
import ghidra.pcode.emu.jit.var.JitMissingVar;
import ghidra.pcode.emu.jit.var.JitVar;
import ghidra.pcode.emu.jit.var.JitVarnodeVar;
import ghidra.program.model.pcode.Varnode;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.objectweb.asm.MethodVisitor;

public interface VarGen<V extends JitVar>
extends ValGen<V> {
    public static <V extends JitVar> VarGen<V> lookup(V v) {
        V v2 = v;
        Objects.requireNonNull(v2);
        V v3 = v2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitIndirectMemoryVar.class, JitDirectMemoryVar.class, JitInputVar.class, JitMissingVar.class, JitMemoryOutVar.class, JitLocalOutVar.class}, v3, n)) {
            case 0 -> {
                JitIndirectMemoryVar imv = (JitIndirectMemoryVar)v3;
                throw new AssertionError();
            }
            case 1 -> {
                JitDirectMemoryVar dmv = (JitDirectMemoryVar)v3;
                yield DirectMemoryVarGen.GEN;
            }
            case 2 -> {
                JitInputVar iv = (JitInputVar)v3;
                yield InputVarGen.GEN;
            }
            case 3 -> {
                JitMissingVar mv = (JitMissingVar)v3;
                yield MissingVarGen.GEN;
            }
            case 4 -> {
                JitMemoryOutVar mov = (JitMemoryOutVar)v3;
                yield MemoryOutVarGen.GEN;
            }
            case 5 -> {
                JitLocalOutVar lov = (JitLocalOutVar)v3;
                yield LocalOutVarGen.GEN;
            }
            default -> throw new AssertionError();
        };
    }

    public static void generateValInitCode(JitCodeGenerator gen, Varnode vn) {
        long start = vn.getOffset();
        long endIncl = start + (long)vn.getSize() - 1L;
        long startBlock = start / 4096L * 4096L;
        long endBlockIncl = endIncl / 4096L * 4096L;
        for (long block = startBlock; block != endBlockIncl + 4096L; block += 4096L) {
            gen.requestFieldForArrDirect(vn.getAddress().getNewAddress(block));
        }
    }

    public static void generateValReadCodeDirect(JitCodeGenerator gen, JitType type, Varnode vn, MethodVisitor rv) {
        TypedAccessGen.lookupReader(gen.getAnalysisContext().getEndian(), type).generateCode(gen, vn, rv);
    }

    public static JitType generateValReadCodeDirect(JitCodeGenerator gen, JitVarnodeVar v, JitTypeBehavior typeReq, MethodVisitor rv) {
        JitType type = typeReq.resolve(gen.getTypeModel().typeOf(v));
        VarGen.generateValReadCodeDirect(gen, type, v.varnode(), rv);
        return type;
    }

    public static void generateValWriteCodeDirect(JitCodeGenerator gen, JitType type, Varnode vn, MethodVisitor rv) {
        TypedAccessGen.lookupWriter(gen.getAnalysisContext().getEndian(), type).generateCode(gen, vn, rv);
    }

    public static void generateValWriteCodeDirect(JitCodeGenerator gen, JitVarnodeVar v, JitType type, MethodVisitor rv) {
        VarGen.generateValWriteCodeDirect(gen, type, v.varnode(), rv);
    }

    public static void generateBirthCode(JitCodeGenerator gen, Set<Varnode> toBirth, MethodVisitor rv) {
        for (Varnode vn : toBirth) {
            for (JitAllocationModel.JvmLocal local : gen.getAllocationModel().localsForVn(vn)) {
                local.generateBirthCode(gen, rv);
            }
        }
    }

    public static void generateRetireCode(JitCodeGenerator gen, Set<Varnode> toRetire, MethodVisitor rv) {
        for (Varnode vn : toRetire) {
            for (JitAllocationModel.JvmLocal local : gen.getAllocationModel().localsForVn(vn)) {
                local.generateRetireCode(gen, rv);
            }
        }
    }

    public static BlockTransition computeBlockTransition(JitCodeGenerator gen, JitControlFlowModel.JitBlock from, JitControlFlowModel.JitBlock to) {
        JitVarScopeModel scopeModel = gen.getVariableScopeModel();
        Set liveFrom = from == null ? Set.of() : scopeModel.getLiveVars(from);
        Set liveTo = to == null ? Set.of() : scopeModel.getLiveVars(to);
        BlockTransition result = new BlockTransition(gen);
        result.toRetire.addAll(liveFrom);
        result.toRetire.removeAll(liveTo);
        result.toBirth.addAll(liveTo);
        result.toBirth.removeAll(liveFrom);
        return result;
    }

    public void generateVarWriteCode(JitCodeGenerator var1, V var2, JitType var3, MethodVisitor var4);

    public record BlockTransition(JitCodeGenerator gen, Set<Varnode> toRetire, Set<Varnode> toBirth) {
        public BlockTransition(JitCodeGenerator gen) {
            this(gen, new LinkedHashSet<Varnode>(), new LinkedHashSet<Varnode>());
        }

        public boolean needed() {
            return !this.toRetire.isEmpty() || !this.toBirth().isEmpty();
        }

        public void generate(MethodVisitor rv) {
            VarGen.generateRetireCode(this.gen, this.toRetire, rv);
            VarGen.generateBirthCode(this.gen, this.toBirth, rv);
        }

        public void generateInv(MethodVisitor rv) {
            VarGen.generateRetireCode(this.gen, this.toBirth, rv);
            VarGen.generateBirthCode(this.gen, this.toRetire, rv);
        }
    }
}

