/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.graph.job;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.RenderContext;
import functioncalls.graph.FcgEdge;
import functioncalls.graph.FcgLevel;
import functioncalls.graph.FcgVertex;
import functioncalls.graph.job.FcgExpandingVertexCollection;
import functioncalls.graph.layout.BowTieLayout;
import ghidra.graph.job.AbstractGraphTransitionJob;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.VisualVertex;
import ghidra.util.Msg;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BowTieExpandVerticesJob
extends AbstractGraphTransitionJob<FcgVertex, FcgEdge> {
    private boolean incoming;
    private FcgLevel expandingLevel;
    private FcgExpandingVertexCollection newVertexCollection;

    public BowTieExpandVerticesJob(GraphViewer<FcgVertex, FcgEdge> viewer, FcgExpandingVertexCollection newVertexCollection, boolean useAnimation) {
        super(viewer, useAnimation);
        this.newVertexCollection = newVertexCollection;
        this.incoming = newVertexCollection.isIncoming();
        this.expandingLevel = newVertexCollection.getExpandingLevel();
        if (!(this.graphLayout instanceof BowTieLayout)) {
            throw new IllegalArgumentException("The current graph layout must be the " + BowTieLayout.class.getSimpleName() + " to use this job");
        }
        Msg.trace((Object)((Object)this), (Object)("\nBow Tie Expand Job - new vertices: " + String.valueOf(newVertexCollection.getNewVertices())));
    }

    protected boolean isTooBigToAnimate() {
        return this.graph.getVertexCount() > 1000;
    }

    protected void updateOpacity(double percentComplete) {
        double x = percentComplete;
        double x2 = x * x;
        double remaining = 1.0 - percentComplete;
        double y = x2 - remaining;
        Set<FcgVertex> newVertices = this.newVertexCollection.getNewVertices();
        double vertexAlpha = x;
        double edgeAlpha = Math.max(y, 0.0);
        for (FcgVertex v : newVertices) {
            v.setAlpha(vertexAlpha);
        }
        Iterable<FcgEdge> newEdges = this.newVertexCollection.getNewEdges();
        for (FcgEdge edge : newEdges) {
            edge.setAlpha(edgeAlpha);
        }
    }

    public boolean canShortcut() {
        return true;
    }

    public void shortcut() {
        this.isShortcut = true;
        if (this.vertexLocations.isEmpty()) {
            this.initializeVertexLocations();
        }
        this.stop();
    }

    protected void initializeVertexLocations() {
        Map<FcgVertex, AbstractGraphTransitionJob.TransitionPoints> destinationLocations = this.createDestinationLocation();
        this.vertexLocations.putAll(destinationLocations);
    }

    private Map<FcgVertex, AbstractGraphTransitionJob.TransitionPoints> createDestinationLocation() {
        Map<FcgVertex, Point2D> finalDestinations = this.arrangeNewVertices();
        HashMap<FcgVertex, AbstractGraphTransitionJob.TransitionPoints> transitions = new HashMap<FcgVertex, AbstractGraphTransitionJob.TransitionPoints>();
        FcgLevel parentLevel = this.expandingLevel.parent();
        Iterable<FcgEdge> newEdges = this.newVertexCollection.getNewEdges();
        Set<FcgVertex> newVertices = this.newVertexCollection.getNewVertices();
        for (FcgEdge e : newEdges) {
            FcgVertex existingVertex;
            FcgLevel existingLevel;
            FcgVertex newVertex = this.incoming ? (FcgVertex)e.getStart() : (FcgVertex)e.getEnd();
            if (!finalDestinations.containsKey((Object)newVertex) || !newVertices.contains((Object)newVertex) || !(existingLevel = (existingVertex = this.incoming ? (FcgVertex)e.getEnd() : (FcgVertex)e.getStart()).getLevel()).equals(parentLevel)) continue;
            Point2D start = (Point2D)this.toLocation((VisualVertex)existingVertex).clone();
            Point2D end = finalDestinations.get((Object)newVertex);
            AbstractGraphTransitionJob.TransitionPoints trans = new AbstractGraphTransitionJob.TransitionPoints((AbstractGraphTransitionJob)this, start, end);
            transitions.put(newVertex, trans);
        }
        return transitions;
    }

    private Map<FcgVertex, Point2D> arrangeNewVertices() {
        BowTieLayout bowTie = (BowTieLayout)this.graphLayout;
        boolean isCondensed = bowTie.isCondensedLayout();
        int widthPadding = isCondensed ? 10 : 50;
        widthPadding *= this.expandingLevel.getDistance();
        int heightPadding = this.calculateHeightPadding(isCondensed);
        FcgLevel parentLevel = this.expandingLevel.parent();
        List<FcgVertex> parentLevelVertices = this.newVertexCollection.getVerticesByLevel(parentLevel);
        if (parentLevelVertices.isEmpty()) {
            return Collections.emptyMap();
        }
        Rectangle existingRowBounds = this.getBounds(parentLevelVertices);
        Msg.trace((Object)((Object)this), (Object)("existing row bounds " + String.valueOf(existingRowBounds)));
        double existingY = existingRowBounds.y;
        double existingCenterX = existingRowBounds.x + existingRowBounds.width / 2;
        List<FcgVertex> allLevelVertices = this.newVertexCollection.getAllVerticesAtNewLevel();
        double newRowWidth = this.getWidth(allLevelVertices, widthPadding);
        double newRowHeight = this.getHeight(allLevelVertices);
        double newRowX = existingCenterX - newRowWidth / 2.0;
        double newRowY = 0.0;
        newRowY = this.newVertexCollection.isIncoming() ? existingY - newRowHeight - (double)heightPadding : existingY + (double)existingRowBounds.height + (double)heightPadding;
        Msg.trace((Object)((Object)this), (Object)("new row bounds " + String.valueOf(new Rectangle2D.Double(newRowX, newRowY, newRowWidth, newRowHeight))));
        Map<FcgVertex, Point2D> locations = this.getExistingLocations(allLevelVertices);
        if (!locations.isEmpty()) {
            return locations;
        }
        RenderContext renderContext = this.viewer.getRenderContext();
        Function shaper = renderContext.getVertexShapeTransformer();
        double x = newRowX;
        double y = newRowY;
        int n = allLevelVertices.size();
        for (int i = 0; i < n; ++i) {
            boolean isLast;
            FcgVertex v = allLevelVertices.get(i);
            Rectangle myBounds = ((Shape)shaper.apply((Object)v)).getBounds();
            double myHalf = myBounds.width / 2;
            double nextHalf = 0.0;
            boolean bl = isLast = i == n - 1;
            if (!isLast) {
                FcgVertex nextV = allLevelVertices.get(i + 1);
                Rectangle nextBounds = ((Shape)shaper.apply((Object)nextV)).getBounds();
                nextHalf = nextBounds.width / 2;
            }
            Point2D.Double p = new Point2D.Double(x, y);
            locations.put(v, p);
            double vWidth = myHalf + (double)widthPadding + nextHalf;
            Msg.trace((Object)((Object)this), (Object)(String.valueOf((Object)v) + " at x,width: " + x + "," + vWidth));
            x += vWidth;
        }
        return locations;
    }

    private int calculateHeightPadding(boolean isCondensed) {
        int basePadding = isCondensed ? 25 : 50;
        double separationFactor = this.expandingLevel.getDistance();
        List<FcgVertex> allLevelVertices = this.newVertexCollection.getAllVerticesAtNewLevel();
        int count = allLevelVertices.size();
        double to = 1.25;
        double power = Math.pow(separationFactor, to);
        int maxPadding = (int)((double)basePadding * power);
        int delta = maxPadding - basePadding;
        double percent = Math.min((float)count / 20.0f, 1.0f);
        int padding = basePadding + (int)((double)delta * percent);
        return padding;
    }

    private Map<FcgVertex, Point2D> getExistingLocations(List<FcgVertex> vertices) {
        HashMap<FcgVertex, Point2D> locations = new HashMap<FcgVertex, Point2D>();
        for (FcgVertex v : vertices) {
            Point2D p = this.toLocation((VisualVertex)v);
            if (p.getX() == 0.0 && p.getY() == 0.0) {
                return new HashMap<FcgVertex, Point2D>();
            }
            locations.put(v, (Point2D)p.clone());
        }
        return locations;
    }

    private Rectangle getBounds(List<FcgVertex> vertices) {
        RenderContext renderContext = this.viewer.getRenderContext();
        Function shaper = renderContext.getVertexShapeTransformer();
        Layout layout = this.viewer.getGraphLayout();
        Rectangle area = null;
        for (FcgVertex v : vertices) {
            Rectangle bounds = ((Shape)shaper.apply((Object)v)).getBounds();
            Point2D loc = (Point2D)layout.apply((Object)v);
            int x = (int)loc.getX();
            int y = (int)loc.getY();
            bounds.setLocation(x, y);
            if (area == null) {
                area = bounds;
            }
            area.add(bounds);
        }
        return area;
    }

    private int getWidth(List<FcgVertex> vertices, int widthPadding) {
        RenderContext renderContext = this.viewer.getRenderContext();
        Function shaper = renderContext.getVertexShapeTransformer();
        int width = 0;
        for (FcgVertex v : vertices) {
            width += ((Shape)shaper.apply((Object)((Object)v))).getBounds().width + widthPadding;
        }
        return width;
    }

    private int getHeight(List<FcgVertex> vertices) {
        RenderContext renderContext = this.viewer.getRenderContext();
        Function shaper = renderContext.getVertexShapeTransformer();
        int height = 0;
        for (FcgVertex v : vertices) {
            height = Math.max(height, ((Shape)shaper.apply((Object)((Object)v))).getBounds().height);
        }
        return height;
    }
}

