/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.graph.job;

import edu.uci.ics.jung.algorithms.layout.Layout;
import functioncalls.graph.FcgDirection;
import functioncalls.graph.FcgEdge;
import functioncalls.graph.FcgLevel;
import functioncalls.graph.FcgVertex;
import ghidra.graph.viewer.GraphViewer;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.map.LazyMap;
import util.CollectionUtils;

public class FcgExpandingVertexCollection {
    private Comparator<FcgVertex> sourceVertexComparator = this::compareVerticesByLayoutPosition;
    private Comparator<FcgVertex> addressComparator = (v1, v2) -> v1.getAddress().compareTo((Object)v2.getAddress());
    private Map<FcgVertex, TreeSet<FcgVertex>> newVerticesBySource = LazyMap.lazyMap(new TreeMap(this.sourceVertexComparator), () -> new TreeSet<FcgVertex>(this.addressComparator));
    private GraphViewer<FcgVertex, FcgEdge> viewer;
    private FcgLevel parentLevel;
    private FcgLevel expandingLevel;
    private Set<FcgVertex> newVertices;
    private Set<FcgEdge> newEdges;
    private Set<FcgEdge> indirectEdges = Collections.emptySet();
    private boolean isIncoming;
    private Iterable<FcgVertex> sources;

    public FcgExpandingVertexCollection(Iterable<FcgVertex> sources, FcgLevel parentLevel, FcgLevel expandingLevel, Set<FcgVertex> newVertices, Set<FcgEdge> newEdges, Set<FcgEdge> allParentLevelEdges, boolean isIncoming, GraphViewer<FcgVertex, FcgEdge> viewer) {
        this.sources = sources;
        this.parentLevel = parentLevel;
        this.newVertices = newVertices;
        this.newEdges = newEdges;
        this.isIncoming = isIncoming;
        this.viewer = viewer;
        this.expandingLevel = expandingLevel;
        for (FcgEdge e : allParentLevelEdges) {
            FcgVertex start = (FcgVertex)e.getStart();
            FcgVertex end = (FcgVertex)e.getEnd();
            FcgLevel startLevel = start.getLevel();
            FcgLevel endLevel = end.getLevel();
            if (expandingLevel.equals(startLevel)) {
                if (expandingLevel.equals(endLevel)) {
                    this.newVerticesBySource.get((Object)start).add(end);
                    this.newVerticesBySource.get((Object)end).add(start);
                    continue;
                }
                this.newVerticesBySource.get((Object)end).add(start);
                continue;
            }
            this.newVerticesBySource.get((Object)start).add(end);
        }
    }

    private int compareVerticesByLayoutPosition(FcgVertex v1, FcgVertex v2) {
        FcgLevel l2;
        Layout layout = this.viewer.getGraphLayout();
        FcgLevel l1 = v1.getLevel();
        int result = l1.compareTo(l2 = v2.getLevel());
        if (result != 0) {
            if (l1.equals(this.parentLevel)) {
                return -1;
            }
            if (l2.equals(this.parentLevel)) {
                return 1;
            }
            return result;
        }
        Point2D p1 = (Point2D)layout.apply((Object)v1);
        Point2D p2 = (Point2D)layout.apply((Object)v2);
        return (int)(p1.getX() - p2.getX());
    }

    public List<FcgVertex> getVerticesByLevel(FcgLevel level) {
        Set<FcgVertex> existingVertices = this.newVerticesBySource.keySet();
        List<FcgVertex> verticesAtLevel = existingVertices.stream().filter(v -> v.getLevel().equals(level)).collect(Collectors.toList());
        return verticesAtLevel;
    }

    public List<FcgVertex> getAllVerticesAtNewLevel() {
        Set<FcgVertex> existingVertices = this.newVerticesBySource.keySet();
        LinkedHashSet sortedVertices = existingVertices.stream().map(v -> this.newVerticesBySource.get(v)).flatMap(set -> set.stream()).filter(v -> v.getLevel().equals(this.expandingLevel)).collect(Collectors.toCollection(LinkedHashSet::new));
        return new ArrayList<FcgVertex>(sortedVertices);
    }

    public Set<FcgVertex> getNewVertices() {
        return this.newVertices;
    }

    public Iterable<FcgEdge> getNewEdges() {
        return IterableUtils.chainedIterable(this.newEdges, this.indirectEdges);
    }

    public Set<FcgEdge> getIndirectEdges() {
        return this.indirectEdges;
    }

    public int getNewEdgeCount() {
        return this.newEdges.size() + this.indirectEdges.size();
    }

    public void setIndirectEdges(Set<FcgEdge> indirectEdges) {
        this.indirectEdges = CollectionUtils.asSet(indirectEdges);
    }

    public FcgLevel getExpandingLevel() {
        return this.expandingLevel;
    }

    public FcgDirection getExpandingDirection() {
        return this.expandingLevel.getDirection();
    }

    public Iterable<FcgVertex> getSources() {
        return this.sources;
    }

    public boolean isIncoming() {
        return this.isIncoming;
    }
}

